/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.cache.LRUDataModelOracleCache;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleIncrementalPayload;
import org.kie.workbench.common.services.datamodel.service.IncrementalDataModelService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class IncrementalDataModelServiceImpl
implements IncrementalDataModelService {
    private LRUDataModelOracleCache cachePackages;
    private KieModuleService moduleService;

    @Inject
    public IncrementalDataModelServiceImpl(@Named(value="PackageDataModelOracleCache") LRUDataModelOracleCache cachePackages, KieModuleService moduleService) {
        this.cachePackages = (LRUDataModelOracleCache)((Object)PortablePreconditions.checkNotNull((String)"cachePackages", (Object)((Object)cachePackages)));
        this.moduleService = (KieModuleService)PortablePreconditions.checkNotNull((String)"moduleService", (Object)moduleService);
    }

    public IncrementalDataModelServiceImpl() {
    }

    public PackageDataModelOracleIncrementalPayload getUpdates(Path resourcePath, Imports imports, String factType) {
        PortablePreconditions.checkNotNull((String)"resourcePath", (Object)resourcePath);
        PortablePreconditions.checkNotNull((String)"imports", (Object)imports);
        PortablePreconditions.checkNotNull((String)"factType", (Object)factType);
        PackageDataModelOracleIncrementalPayload dataModel = new PackageDataModelOracleIncrementalPayload();
        try {
            KieModule project = this.resolveModule(resourcePath);
            if (project == null) {
                return dataModel;
            }
            Package pkg = this.resolvePackage(resourcePath);
            if (pkg == null) {
                return dataModel;
            }
            String fullyQualifiedClassName = factType;
            PackageDataModelOracle oracle = this.cachePackages.assertPackageDataModelOracle(project, pkg);
            if (oracle.getModuleModelFields().get(fullyQualifiedClassName) == null) {
                for (Import imp : imports.getImports()) {
                    if (!imp.getType().endsWith(factType)) continue;
                    fullyQualifiedClassName = imp.getType();
                    break;
                }
            }
            if (oracle.getModuleModelFields().get(fullyQualifiedClassName) == null) {
                fullyQualifiedClassName = pkg.getPackageName() + "." + factType;
            }
            if (oracle.getModuleModelFields().get(fullyQualifiedClassName) == null) {
                return dataModel;
            }
            DataModelOracleUtilities.populateDataModel(oracle, dataModel, fullyQualifiedClassName);
            return dataModel;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    private KieModule resolveModule(Path resourcePath) {
        return (KieModule)this.moduleService.resolveModule(resourcePath);
    }

    private Package resolvePackage(Path resourcePath) {
        return this.moduleService.resolvePackage(resourcePath);
    }
}

