/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.kie.workbench.common.screens.datasource.management.metadata.CatalogMetadata;
import org.kie.workbench.common.screens.datasource.management.metadata.DatabaseMetadata;
import org.kie.workbench.common.screens.datasource.management.metadata.SchemaMetadata;
import org.kie.workbench.common.screens.datasource.management.metadata.TableMetadata;

public class DatabaseMetadataUtil {
    public static DatabaseMetadata getMetadata(Connection conn, boolean includeCatalogs, boolean includeSchemas) throws Exception {
        try {
            ResultSet rs;
            DatabaseMetadata result = new DatabaseMetadata();
            DatabaseMetaData sqlMetadata = conn.getMetaData();
            result.setDatabaseType(DatabaseMetadataUtil.getDatabaseType(sqlMetadata.getDatabaseProductName()));
            result.setDatabaseProductName(sqlMetadata.getDatabaseProductName());
            result.setDatabaseProductVersion(sqlMetadata.getDatabaseProductVersion());
            result.setDriverName(sqlMetadata.getDriverName());
            result.setDriverVersion(sqlMetadata.getDriverVersion());
            result.setDriverMajorVersion(sqlMetadata.getDriverMajorVersion());
            result.setDriverMinorVersion(sqlMetadata.getDriverMinorVersion());
            if (includeCatalogs) {
                ArrayList<CatalogMetadata> catalogs = new ArrayList<CatalogMetadata>();
                rs = sqlMetadata.getCatalogs();
                while (rs.next()) {
                    catalogs.add(new CatalogMetadata(rs.getString("TABLE_CAT")));
                }
                rs.close();
                result.setCatalogs(catalogs);
            }
            if (includeSchemas) {
                ArrayList<SchemaMetadata> schemas = new ArrayList<SchemaMetadata>();
                rs = sqlMetadata.getSchemas();
                while (rs.next()) {
                    schemas.add(new SchemaMetadata(rs.getString("TABLE_CATALOG"), rs.getString("TABLE_SCHEM")));
                }
                rs.close();
                result.setSchemas(schemas);
            }
            DatabaseMetadata databaseMetadata = result;
            return databaseMetadata;
        }
        catch (Exception e) {
            throw new Exception("It was not possible to read database metadata due to the following error: " + e.getMessage());
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
    }

    public static List<TableMetadata> findTables(Connection conn, String schema, String tableNamePattern, DatabaseMetadata.TableType ... types) throws Exception {
        try {
            ArrayList<TableMetadata> result = new ArrayList<TableMetadata>();
            DatabaseMetaData sqlMetadata = conn.getMetaData();
            ResultSet rs = sqlMetadata.getTables(null, schema, tableNamePattern, DatabaseMetadataUtil.toSqlTypes(types));
            while (rs.next()) {
                TableMetadata tableMetadata = new TableMetadata(rs.getString("TABLE_CAT"), rs.getString("TABLE_SCHEM"), rs.getString("TABLE_NAME"), rs.getString("TABLE_TYPE"));
                result.add(tableMetadata);
            }
            rs.close();
            ArrayList<TableMetadata> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new Exception("It was not possible to read schema tables due to the following error: " + e.getMessage());
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
    }

    public static DatabaseMetadata.DatabaseType getDatabaseType(String dbProductName) {
        String lowerCasedName = dbProductName.toLowerCase();
        if (lowerCasedName.contains("h2")) {
            return DatabaseMetadata.DatabaseType.H2;
        }
        if (lowerCasedName.contains("mysql")) {
            return DatabaseMetadata.DatabaseType.MYSQL;
        }
        if (lowerCasedName.contains("mariadb")) {
            return DatabaseMetadata.DatabaseType.MARIADB;
        }
        if (lowerCasedName.contains("postgresql")) {
            return DatabaseMetadata.DatabaseType.POSTGRESQL;
        }
        if (lowerCasedName.contains("oracle")) {
            return DatabaseMetadata.DatabaseType.ORACLE;
        }
        if (lowerCasedName.contains("microsoft") && lowerCasedName.contains("sql") && lowerCasedName.contains("server")) {
            return DatabaseMetadata.DatabaseType.SQLSERVER;
        }
        if (lowerCasedName.contains("db2")) {
            return DatabaseMetadata.DatabaseType.DB2;
        }
        return null;
    }

    private static String[] toSqlTypes(DatabaseMetadata.TableType[] types) {
        int i;
        HashSet<DatabaseMetadata.TableType> typesSet = new HashSet<DatabaseMetadata.TableType>();
        String[] result = null;
        if (types != null) {
            for (i = 0; i < types.length; ++i) {
                typesSet.add(types[i]);
            }
        }
        if (!typesSet.isEmpty() && !typesSet.contains(DatabaseMetadata.TableType.ALL)) {
            result = new String[typesSet.size()];
            i = 0;
            for (DatabaseMetadata.TableType type : typesSet) {
                result[i++] = DatabaseMetadataUtil.toSqlType(type);
            }
        }
        return result;
    }

    private static String toSqlType(DatabaseMetadata.TableType type) {
        switch (type) {
            case TABLE: {
                return "TABLE";
            }
            case SYSTEM_TABLE: {
                return "SYSTEM TABLE";
            }
            case VIEW: {
                return "VIEW";
            }
            case SYSTEM_VIEW: {
                return "SYSTEM VIEW";
            }
            case SEQUENCE: {
                return "SEQUENCE";
            }
        }
        return null;
    }
}

