/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.kie.workbench.common.services.refactoring.model.index.terms.CompositeIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

public class NormalizedTerms {
    private final Map<String, ValueIndexTerm> normalizedTerms = new HashMap<String, ValueIndexTerm>();

    public NormalizedTerms(Set<ValueIndexTerm> terms, String ... termNames) {
        this.checkSize(terms, termNames);
        this.addTerms(terms);
        this.checkTermsExist(termNames);
    }

    private void checkSize(Set<ValueIndexTerm> terms, String[] termNames) {
        if (terms.size() != termNames.length) {
            throw new IllegalArgumentException(this.getExceptionMessage(termNames));
        }
    }

    private void addTerms(Set<ValueIndexTerm> terms) {
        for (ValueIndexTerm term : terms) {
            if (term instanceof CompositeIndexTerm) {
                this.normalizedTerms.put(((CompositeIndexTerm)term).getTermBase(), term);
                continue;
            }
            this.normalizedTerms.put(term.getTerm(), term);
        }
    }

    private void checkTermsExist(String[] termNames) {
        for (String termName : termNames) {
            this.checkTermExists(termName);
        }
    }

    private void checkTermExists(String termName) {
        if (!this.normalizedTerms.containsKey(termName)) {
            throw new IllegalArgumentException("Required term has not been provided. Required '" + termName + "'.");
        }
    }

    public ValueIndexTerm get(String term) {
        this.checkTermExists(term);
        return this.normalizedTerms.get(term);
    }

    private String getExceptionMessage(String[] termNames) {
        StringBuilder message = new StringBuilder("Required terms have not been provided. Require '");
        Iterator<String> iterator = Arrays.asList(termNames).iterator();
        while (iterator.hasNext()) {
            message.append(iterator.next());
            if (!iterator.hasNext()) continue;
            message.append(", ");
        }
        message.append("'.");
        return message.toString();
    }
}

