/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.utils;

import com.google.common.base.Preconditions;
import java.security.Principal;
import java.util.Arrays;
import org.jbpm.workbench.ks.security.KeyCloakTokenCredentialsProvider;
import org.keycloak.KeycloakPrincipal;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.CredentialsProvider;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.balancer.LoadBalancer;
import org.kie.server.client.credentials.EnteredCredentialsProvider;
import org.kie.server.client.credentials.EnteredTokenCredentialsProvider;
import org.kie.server.client.credentials.SubjectCredentialsProvider;
import org.kie.server.common.KeyStoreHelperUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.security.server.SecurityIntegrationFilter;

public class KieServerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerUtils.class);
    private static boolean KIE_SERVER_FORM_RENDERER = Boolean.parseBoolean(System.getProperty("org.jbpm.wb.forms.renderer.ext", "false"));

    public static KieServicesClient createKieServicesClient(String ... capabilities) {
        String kieServerEndpoint = System.getProperty("org.kie.server.location");
        Preconditions.checkNotNull((Object)kieServerEndpoint, (Object)"Missing Kie Server system property org.kie.server.location");
        return KieServerUtils.createKieServicesClient(kieServerEndpoint, null, KieServerUtils.getCredentialsProvider(), capabilities);
    }

    public static KieServicesClient createAdminKieServicesClient(String ... capabilities) {
        String kieServerEndpoint = System.getProperty("org.kie.server.location");
        Preconditions.checkNotNull((Object)kieServerEndpoint, (Object)"Missing Kie Server system property org.kie.server.location");
        return KieServerUtils.createKieServicesClient(kieServerEndpoint, null, KieServerUtils.getAdminCredentialsProvider(), capabilities);
    }

    public static KieServicesClient createKieServicesClient(String endpoint, ClassLoader classLoader, String login, String password, String ... capabilities) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)endpoint, (String)login, (String)password);
        return KieServerUtils.createKieServicesClient(endpoint, classLoader, configuration, capabilities);
    }

    public static KieServicesClient createKieServicesClient(String endpoint, ClassLoader classLoader, CredentialsProvider credentialsProvider, String ... capabilities) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)endpoint, (CredentialsProvider)credentialsProvider);
        return KieServerUtils.createKieServicesClient(endpoint, classLoader, configuration, capabilities);
    }

    public static KieServicesClient createKieServicesClient(String endpoint, ClassLoader classLoader, KieServicesConfiguration configuration, String ... capabilities) {
        LOGGER.debug("Creating client that will use following endpoint {}", (Object)endpoint);
        configuration.setTimeout(60000L);
        if (capabilities != null) {
            configuration.setCapabilities(Arrays.asList(capabilities));
        }
        configuration.setMarshallingFormat(KieServerUtils.isKieServerRendererEnabled() ? MarshallingFormat.JSON : MarshallingFormat.XSTREAM);
        configuration.setLoadBalancer(LoadBalancer.getDefault((String)endpoint));
        KieServicesClient kieServicesClient = classLoader == null ? KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration) : KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration, (ClassLoader)classLoader);
        LOGGER.debug("KieServerClient created successfully for endpoint {}", (Object)endpoint);
        return kieServicesClient;
    }

    public static CredentialsProvider getCredentialsProvider() {
        return new CredentialsProvider(){
            KeyCloakTokenCredentialsProvider keyCloakProvider = new KeyCloakTokenCredentialsProvider();
            SubjectCredentialsProvider subjectProvider = new SubjectCredentialsProvider();

            public String getHeaderName() {
                return "Authorization";
            }

            public String getAuthorization() {
                Principal principal = SecurityIntegrationFilter.getRequest().getUserPrincipal();
                if (principal instanceof KeycloakPrincipal) {
                    return this.keyCloakProvider.getAuthorization();
                }
                return this.subjectProvider.getAuthorization();
            }
        };
    }

    public static CredentialsProvider getAdminCredentialsProvider() {
        if (System.getProperty("org.kie.server.token") != null) {
            return new EnteredTokenCredentialsProvider(System.getProperty("org.kie.server.token"));
        }
        return new EnteredCredentialsProvider(System.getProperty("org.kie.server.user", "kieserver"), KeyStoreHelperUtil.loadServerPassword());
    }

    public static boolean isKieServerRendererEnabled() {
        return KIE_SERVER_FORM_RENDERER;
    }
}

