/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.editor.backend.service.impl.helpers;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.kie.workbench.common.forms.editor.backend.service.impl.helpers.AbstractFormDefinitionHelper;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.forms.services.backend.util.UIDGenerator;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.backend.service.helper.CopyHelper;
import org.uberfire.ext.layout.editor.api.editor.LayoutColumn;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;
import org.uberfire.io.IOService;

@ApplicationScoped
public class FormDefinitionCopyHelper
extends AbstractFormDefinitionHelper
implements CopyHelper {
    @Inject
    public FormDefinitionCopyHelper(@Named(value="ioStrategy") IOService ioService, FormDefinitionSerializer serializer, CommentedOptionFactory commentedOptionFactory) {
        super(serializer, ioService, commentedOptionFactory);
    }

    @Override
    protected void processFormDefinition(FormDefinition formDefinition, Path formPath) {
        super.processFormDefinition(formDefinition, formPath);
        String newFormId = UIDGenerator.generateUID();
        formDefinition.setId(newFormId);
        LayoutTemplate layout = formDefinition.getLayoutTemplate();
        if (layout != null) {
            layout.getRows().stream().forEach(row -> this.process((LayoutRow)row, newFormId));
        }
    }

    private void process(LayoutRow row, String formId) {
        row.getLayoutColumns().stream().forEach(column -> this.process((LayoutColumn)column, formId));
    }

    private void process(LayoutColumn column, String formId) {
        column.getLayoutComponents().stream().forEach(component -> this.process((LayoutComponent)component, formId));
    }

    private void process(LayoutComponent component, String formId) {
        Map properties = component.getProperties();
        if (properties.containsKey("field_id") && properties.containsKey("form_id")) {
            properties.put("form_id", formId);
        }
    }
}

