/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.pom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.guvnor.structure.backend.pom.PomEditor;
import org.guvnor.structure.pom.DynamicPomDependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;
import org.uberfire.java.nio.file.StandardOpenOption;

public class PomEditorDefault
implements PomEditor {
    private static final String DELIMITER = ":";
    private final Logger logger = LoggerFactory.getLogger(PomEditorDefault.class);
    private MavenXpp3Reader reader = new MavenXpp3Reader();
    private MavenXpp3Writer writer = new MavenXpp3Writer();

    @Override
    public boolean addDependency(DynamicPomDependency dep, org.uberfire.backend.vfs.Path pomPath) {
        if (dep == null || !this.isGroupIDValid(dep) || !this.isArtifactIDValid(dep)) {
            return false;
        }
        try {
            Dependency pomDep = this.getMavenDependency(dep);
            Path filePath = Paths.get((String)pomPath.toURI(), (String[])new String[0]);
            Model model = this.getPOMModel(filePath);
            Map<String, String> keys = this.getKeysFromDeps(model.getDependencies());
            String keyDep = this.getKeyFromDep(dep);
            if (keys.containsKey(keyDep)) {
                String versionKey = keys.get(keyDep);
                List modelDeps = model.getDependencies();
                for (Dependency modelDep : modelDeps) {
                    if (!modelDep.getGroupId().equals(dep.getGroupID()) || !modelDep.getArtifactId().equals(dep.getArtifactID())) continue;
                    modelDep.setVersion(versionKey);
                }
                return false;
            }
            model.getDependencies().add(pomDep);
            this.writePOMModelOnFS(filePath, model);
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    @Override
    public boolean addDependencies(List<DynamicPomDependency> deps, org.uberfire.backend.vfs.Path pomPath) {
        if (deps.isEmpty()) {
            return false;
        }
        boolean result = false;
        try {
            Path filePath = Paths.get((String)pomPath.toURI(), (String[])new String[0]);
            Model model = this.getPOMModel(filePath);
            Map<String, String> keys = this.getKeysFromDeps(model.getDependencies());
            for (DynamicPomDependency dep : deps) {
                String keyDep = this.getKeyFromDep(dep);
                if (!keys.containsKey(keyDep)) {
                    Dependency pomDep = this.getMavenDependency(dep);
                    model.getDependencies().add(pomDep);
                    result = true;
                    continue;
                }
                List modelDeps = model.getDependencies();
                for (Dependency modelDep : modelDeps) {
                    if (!modelDep.getGroupId().equals(dep.getGroupID()) || !modelDep.getArtifactId().equals(dep.getArtifactID()) || modelDep.getVersion().equals(dep.getVersion())) continue;
                    modelDep.setVersion(dep.getVersion());
                    result = true;
                }
            }
            if (result) {
                this.writePOMModelOnFS(filePath, model);
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            result = false;
        }
        return result;
    }

    private String getKeyFromDep(DynamicPomDependency dep) {
        StringBuilder sb = new StringBuilder();
        sb.append(dep.getGroupID()).append(DELIMITER).append(dep.getArtifactID());
        return sb.toString();
    }

    private Map<String, String> getKeysFromDeps(List<Dependency> deps) {
        HashMap<String, String> depsMap = new HashMap<String, String>(deps.size());
        for (Dependency dep : deps) {
            StringBuilder sb = new StringBuilder();
            sb.append(dep.getGroupId()).append(DELIMITER).append(dep.getArtifactId());
            depsMap.put(sb.toString(), dep.getVersion());
        }
        return depsMap;
    }

    private void writePOMModelOnFS(Path filePath, Model model) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writer.write((OutputStream)baos, model);
        Files.write((Path)filePath, (byte[])baos.toByteArray(), (OpenOption[])new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING});
    }

    private Model getPOMModel(Path filePath) throws IOException, XmlPullParserException {
        return this.reader.read((InputStream)new ByteArrayInputStream(Files.readAllBytes((Path)filePath)));
    }

    private Dependency getMavenDependency(DynamicPomDependency dep) {
        Dependency pomDep = new Dependency();
        pomDep.setGroupId(dep.getGroupID());
        pomDep.setArtifactId(dep.getArtifactID());
        if (!dep.getVersion().isEmpty()) {
            pomDep.setVersion(dep.getVersion());
        }
        return pomDep;
    }

    private boolean isGroupIDValid(DynamicPomDependency dep) {
        return dep.getGroupID() != null && !dep.getGroupID().isEmpty();
    }

    private boolean isArtifactIDValid(DynamicPomDependency dep) {
        return dep.getArtifactID() != null && !dep.getArtifactID().isEmpty();
    }
}

