/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.backend.repositories.BranchAccessAuthorizer;
import org.guvnor.structure.backend.repositories.git.GitRepositoryBuilder;
import org.guvnor.structure.backend.repositories.git.hooks.PostCommitNotificationService;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryExternalUpdateEvent;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.PasswordService;
import org.guvnor.structure.server.repositories.RepositoryFactoryHelper;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.commons.validation.Preconditions;
import org.uberfire.io.IOService;
import org.uberfire.spaces.SpacesAPI;

@ApplicationScoped
public class GitRepositoryFactoryHelper
implements RepositoryFactoryHelper {
    private IOService indexedIOService;
    private IOService notIndexedIOService;
    private SpacesAPI spacesAPI;
    private Event<RepositoryExternalUpdateEvent> repositoryExternalUpdate;
    private PostCommitNotificationService postCommitNotificationService;
    private BranchAccessAuthorizer branchAccessAuthorizer;
    private PasswordService secureService;

    public GitRepositoryFactoryHelper() {
    }

    @Inject
    public GitRepositoryFactoryHelper(@Named(value="ioStrategy") IOService indexedIOService, @Named(value="configIO") IOService notIndexedIOService, SpacesAPI spacesAPI, Event<RepositoryExternalUpdateEvent> repositoryExternalUpdate, PostCommitNotificationService postCommitNotificationService, BranchAccessAuthorizer branchAccessAuthorizer, PasswordService secureService) {
        this.indexedIOService = indexedIOService;
        this.notIndexedIOService = notIndexedIOService;
        this.spacesAPI = spacesAPI;
        this.repositoryExternalUpdate = repositoryExternalUpdate;
        this.postCommitNotificationService = postCommitNotificationService;
        this.branchAccessAuthorizer = branchAccessAuthorizer;
        this.secureService = secureService;
    }

    public boolean accept(RepositoryInfo repositoryInfo) {
        Preconditions.checkNotNull((String)"repositoryInfo", (Object)repositoryInfo);
        String schemeConfigItem = repositoryInfo.getScheme();
        PortablePreconditions.checkNotEmpty((String)"schemeConfigItem", (String)schemeConfigItem);
        return GitRepository.SCHEME.toString().equals(schemeConfigItem);
    }

    public Repository newRepository(RepositoryInfo repositoryInfo) {
        this.validate(repositoryInfo);
        boolean avoidIndex = repositoryInfo.isAvoidIndex();
        if (avoidIndex) {
            return new GitRepositoryBuilder(this.notIndexedIOService, this.secureService, this.spacesAPI, this.repositoryExternalUpdate, this.postCommitNotificationService, this.branchAccessAuthorizer).build(repositoryInfo);
        }
        return new GitRepositoryBuilder(this.indexedIOService, this.secureService, this.spacesAPI, this.repositoryExternalUpdate, this.postCommitNotificationService, this.branchAccessAuthorizer).build(repositoryInfo);
    }

    private void validate(RepositoryInfo repositoryInfo) {
        Preconditions.checkNotNull((String)"repositoryInfo", (Object)repositoryInfo);
        String schemeConfigItem = repositoryInfo.getScheme();
        PortablePreconditions.checkNotEmpty((String)"schemeConfigItem", (String)schemeConfigItem);
    }
}

