/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.jms;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.api.model.Wrapped;
import org.kie.server.client.jms.ResponseCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingResponseCallback
implements ResponseCallback {
    private static final Logger logger = LoggerFactory.getLogger(BlockingResponseCallback.class);
    private BlockingQueue<ServiceResponsesList> responses;
    private Marshaller marshaller;

    public BlockingResponseCallback(Marshaller marshaller) {
        this.marshaller = marshaller;
        this.responses = new ArrayBlockingQueue<ServiceResponsesList>(10);
    }

    public BlockingResponseCallback(Marshaller marshaller, int queueSize) {
        this.marshaller = marshaller;
        this.responses = new ArrayBlockingQueue<ServiceResponsesList>(queueSize);
    }

    @Override
    public void onResponse(String selector, ServiceResponsesList response) {
        logger.debug("Message response {} for selector {} delivered to callback", (Object)response, (Object)selector);
        try {
            this.responses.put(response);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.debug("Interrupted exception while putting message to response queue in callback");
        }
    }

    @Override
    public ServiceResponsesList get() {
        try {
            return this.responses.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.debug("Interrupted exception while taking message from responses queue in callback");
            return null;
        }
    }

    @Override
    public <T> T get(Class<T> type) {
        if (this.marshaller == null) {
            throw new IllegalStateException("No marshaller given, can't use get(Class) to return response");
        }
        ServiceResponsesList responsesList = this.get();
        if (responsesList.getResponses() == null || responsesList.getResponses().isEmpty()) {
            logger.debug("No data found in the response, returning null");
            return null;
        }
        ServiceResponse response = (ServiceResponse)responsesList.getResponses().get(0);
        if (response.getType().equals((Object)KieServiceResponse.ResponseType.SUCCESS)) {
            Object result = response.getResult();
            if (result instanceof String) {
                logger.debug("Response '{}' of type string, unmarshalling it...", result);
                result = this.marshaller.unmarshall((String)result, type);
                logger.debug("Result after unmarshall operation {}", result);
            }
            if (result instanceof Wrapped) {
                result = ((Wrapped)result).unwrap();
            }
            return (T)result;
        }
        logger.debug("Non successful response '{}', returning null", (Object)response.getMsg());
        return null;
    }
}

