/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.connections.ldap;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionManagerService;

class LdapConnectionManagerRegistry {
    private volatile Map<String, LdapConnectionManagerService> connectionManagerServices = Collections.emptyMap();

    LdapConnectionManagerRegistry() {
    }

    synchronized void addLdapConnectionManagerService(String name, LdapConnectionManagerService service) {
        Map<String, LdapConnectionManagerService> connectionManagerServices = this.connectionManagerServices;
        connectionManagerServices = new HashMap<String, LdapConnectionManagerService>(connectionManagerServices);
        connectionManagerServices.put(name, service);
        this.connectionManagerServices = Collections.unmodifiableMap(connectionManagerServices);
    }

    synchronized void removeLdapConnectionManagerService(String name) {
        Map<String, LdapConnectionManagerService> connectionManagerServices = this.connectionManagerServices;
        connectionManagerServices = new HashMap<String, LdapConnectionManagerService>(connectionManagerServices);
        connectionManagerServices.remove(name);
        this.connectionManagerServices = Collections.unmodifiableMap(connectionManagerServices);
    }

    Collection<LdapConnectionManagerService> availableServices() {
        return this.connectionManagerServices.values();
    }
}

