/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.refactoring.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.KPropertyImpl;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValuePartReferenceIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueReferenceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.ext.metadata.model.KProperty;

public class ResourceReference
implements IndexElementsGenerator {
    private final String resourceFQN;
    private final ResourceType resourceType;
    private Map<String, ValuePartReferenceIndexTerm> fieldNamepartReferenceMap;

    public ResourceReference(String resourceFQN, ResourceType resoureType) {
        this.resourceFQN = (String)PortablePreconditions.checkNotNull((String)"resourceFQN", (Object)resourceFQN);
        this.resourceType = (ResourceType)((Object)PortablePreconditions.checkNotNull((String)"resourceType", (Object)((Object)resoureType)));
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void addPartReference(String partName, PartType partType) {
        if (this.fieldNamepartReferenceMap == null) {
            this.fieldNamepartReferenceMap = new HashMap<String, ValuePartReferenceIndexTerm>(4);
        }
        this.fieldNamepartReferenceMap.put(partName, new ValuePartReferenceIndexTerm(this.resourceFQN, partName, partType));
    }

    public void addPartReference(Map<String, ValuePartReferenceIndexTerm> partReferences) {
        if (partReferences != null && !partReferences.isEmpty()) {
            if (this.fieldNamepartReferenceMap == null) {
                this.fieldNamepartReferenceMap = new HashMap<String, ValuePartReferenceIndexTerm>(4);
            }
            this.fieldNamepartReferenceMap.putAll(partReferences);
        }
    }

    public Map<String, ValuePartReferenceIndexTerm> getPartReferences() {
        if (this.fieldNamepartReferenceMap == null) {
            return Collections.emptyMap();
        }
        return this.fieldNamepartReferenceMap;
    }

    @Override
    public List<KProperty<?>> toIndexElements() {
        ArrayList indexElements = new ArrayList();
        if (this.resourceFQN != null) {
            ValueReferenceIndexTerm refTerm = new ValueReferenceIndexTerm(this.resourceFQN, this.resourceType);
            indexElements.add(new KPropertyImpl<String>(refTerm.getTerm(), refTerm.getValue()));
        }
        if (this.fieldNamepartReferenceMap != null) {
            this.fieldNamepartReferenceMap.values().forEach(refPartTerm -> indexElements.add(new KPropertyImpl<String>(refPartTerm.getTerm(), refPartTerm.getValue())));
        }
        return indexElements;
    }

    public String toString() {
        return "ref:" + this.resourceType.toString() + " => " + this.resourceFQN;
    }
}

