/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.server;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.backend.server.utils.PathUtil;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.screens.examples.backend.server.BaseProjectImportService;
import org.kie.workbench.common.screens.examples.model.Credentials;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.screens.examples.service.ProjectImportService;
import org.kie.workbench.common.screens.examples.validation.ImportProjectValidators;
import org.kie.workbench.common.screens.projecteditor.service.ProjectScreenService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;

@Service
@ApplicationScoped
public class ProjectImportServiceImpl
extends BaseProjectImportService
implements ProjectImportService {
    private Logger logger = LoggerFactory.getLogger(ProjectImportServiceImpl.class);
    private RepositoryFactory repositoryFactory;
    private final Set<Repository> clonedRepositories = new HashSet<Repository>();

    @Inject
    public ProjectImportServiceImpl(@Named(value="ioStrategy") IOService ioService, MetadataService metadataService, RepositoryFactory repositoryFactory, KieModuleService moduleService, ImportProjectValidators validators, PathUtil pathUtil, WorkspaceProjectService projectService, ProjectScreenService projectScreenService, Event<NewProjectEvent> newProjectEvent, RepositoryService repoService, SpaceConfigStorageRegistry spaceConfigStorageRegistry) {
        super(ioService, metadataService, validators, moduleService, projectService, projectScreenService, spaceConfigStorageRegistry, pathUtil, repoService, newProjectEvent);
        this.repositoryFactory = repositoryFactory;
    }

    @Override
    protected Repository resolveGitRepository(ExampleRepository repository) {
        try {
            String url = repository.getUrl();
            String alias = this.getRepositoryAlias(url);
            Credentials credentials = repository.getCredentials();
            String username = null;
            String password = null;
            if (credentials != null) {
                username = credentials.getUsername();
                password = credentials.getPassword();
            }
            Map<String, Object> env = this.buildGitEnv(url, username, password, true);
            RepositoryInfo repositoryConfig = this.createConfigGroup(alias, env);
            Repository repo = this.repositoryFactory.newRepository(repositoryConfig);
            this.clonedRepositories.add(repo);
            return repo;
        }
        catch (Exception e) {
            this.logger.error("Error during create repository", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int priority() {
        return 0;
    }

    public void dispose() {
        for (Repository repository : this.clonedRepositories) {
            try {
                if (!repository.getDefaultBranch().isPresent()) continue;
                this.ioService.delete(Paths.convert((Path)((Branch)repository.getDefaultBranch().get()).getPath()).getFileSystem().getPath(null, new String[0]), new DeleteOption[0]);
            }
            catch (Exception e) {
                this.logger.warn("Unable to remove transient Repository '" + repository.getAlias() + "'.", (Throwable)e);
            }
        }
    }

    @Override
    protected ImportProject makeExampleProject(Module module, ExampleRepository repository) {
        String description = this.readDescription(module);
        List<String> tags = this.getTags(module);
        return new ImportProject(module.getRootPath(), module.getModuleName(), description, repository.getUrl(), tags, repository.getCredentials(), this.getBranches(this.getProjectRoot(module.getRootPath()), module.getRootPath()), true);
    }
}

