/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.queryresults.AbstractQueryResult;
import org.mariadb.jdbc.internal.queryresults.NoSuchColumnException;
import org.mariadb.jdbc.internal.queryresults.ResultSetType;
import org.mariadb.jdbc.internal.queryresults.SelectQueryResult;
import org.mariadb.jdbc.internal.queryresults.StreamingSelectResult;
import org.mariadb.jdbc.internal.queryresults.ValueObject;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class CachedSelectResult
extends SelectQueryResult {
    protected short warningCount;
    private List<ValueObject[]> resultSet;
    private int rowPointer;

    public CachedSelectResult(ColumnInformation[] ci, List<ValueObject[]> result, short warningCount) {
        this.columnInformation = ci;
        this.resultSet = result;
        this.warningCount = warningCount;
        this.rowPointer = -1;
    }

    @Override
    public void addResult(AbstractQueryResult other) {
        if (other.prepareResult != null) {
            this.prepareResult = other.prepareResult;
        }
        this.isClosed = other.isClosed();
    }

    public static CachedSelectResult createCachedSelectResult(StreamingSelectResult streamingResult) throws IOException, QueryException {
        ArrayList<ValueObject[]> valueObjects = new ArrayList<ValueObject[]>();
        while (streamingResult.next()) {
            valueObjects.add(streamingResult.values);
        }
        CachedSelectResult qr = new CachedSelectResult(streamingResult.columnInformation, valueObjects, streamingResult.warningCount);
        streamingResult.close();
        return qr;
    }

    @Override
    public boolean next() throws IOException, QueryException {
        ++this.rowPointer;
        return this.rowPointer < this.resultSet.size();
    }

    @Override
    public short getWarnings() {
        return this.warningCount;
    }

    @Override
    public String getMessage() {
        return null;
    }

    @Override
    public ColumnInformation[] getColumnInformation() {
        return this.columnInformation;
    }

    @Override
    public ValueObject getValueObject(int position) throws NoSuchColumnException {
        if (this.rowPointer < 0) {
            throw new NoSuchColumnException("Current position is before the first row");
        }
        if (this.rowPointer >= this.resultSet.size()) {
            throw new NoSuchColumnException("Current position is after the last row");
        }
        ValueObject[] row = this.resultSet.get(this.rowPointer);
        if (position < 0 || position >= row.length) {
            throw new NoSuchColumnException("No such column: " + position);
        }
        return row[position];
    }

    @Override
    public int getRows() {
        return this.resultSet.size();
    }

    @Override
    public void moveRowPointerTo(int pointerPosition) {
        this.rowPointer = pointerPosition;
    }

    @Override
    public int getRowPointer() {
        return this.rowPointer;
    }

    @Override
    public ResultSetType getResultSetType() {
        return ResultSetType.SELECT;
    }

    @Override
    public boolean isBeforeFirst() {
        if (this.resultSet.size() == 0) {
            return false;
        }
        return this.getRowPointer() == -1;
    }

    @Override
    public boolean isAfterLast() {
        if (this.resultSet.size() == 0) {
            return false;
        }
        return this.rowPointer >= this.resultSet.size();
    }
}

