/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.filter;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dashbuilder.dataset.date.TimeFrame;
import org.dashbuilder.dataset.engine.filter.DataSetFilterContext;
import org.dashbuilder.dataset.engine.filter.DataSetFunction;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;

public class CoreFunction
extends DataSetFunction {
    private CoreFunctionFilter coreFunctionFilter = null;
    Map<String, TimeFrameLimits> _timeFrameExprCache = new HashMap<String, TimeFrameLimits>();

    public CoreFunction(DataSetFilterContext ctx, CoreFunctionFilter coreFunctionFilter) {
        super(ctx, (ColumnFilter)coreFunctionFilter);
        this.coreFunctionFilter = coreFunctionFilter;
    }

    public Comparable getCurrentValue() {
        return (Comparable)this.getDataColumn().getValues().get(this.getContext().getCurrentRow());
    }

    public Comparable getParameter(int index) {
        if (index >= this.coreFunctionFilter.getParameters().size()) {
            return null;
        }
        return (Comparable)this.coreFunctionFilter.getParameters().get(index);
    }

    public List<Comparable> getParameters() {
        return this.coreFunctionFilter.getParameters();
    }

    @Override
    public boolean pass() {
        CoreFunctionType type = this.coreFunctionFilter.getType();
        if (CoreFunctionType.IS_NULL.equals((Object)type)) {
            return this.isNull(this.getCurrentValue());
        }
        if (CoreFunctionType.NOT_NULL.equals((Object)type)) {
            return this.isNotNull(this.getCurrentValue());
        }
        if (CoreFunctionType.EQUALS_TO.equals((Object)type)) {
            return this.isEqualsTo(this.getCurrentValue());
        }
        if (CoreFunctionType.NOT_EQUALS_TO.equals((Object)type)) {
            return this.isNotEqualsTo(this.getCurrentValue());
        }
        if (CoreFunctionType.LIKE_TO.equals((Object)type)) {
            return this.isLikeTo(this.getCurrentValue());
        }
        if (CoreFunctionType.LOWER_THAN.equals((Object)type)) {
            return this.isLowerThan(this.getCurrentValue());
        }
        if (CoreFunctionType.LOWER_OR_EQUALS_TO.equals((Object)type)) {
            return this.isLowerThanOrEqualsTo(this.getCurrentValue());
        }
        if (CoreFunctionType.GREATER_THAN.equals((Object)type)) {
            return this.isGreaterThan(this.getCurrentValue());
        }
        if (CoreFunctionType.GREATER_OR_EQUALS_TO.equals((Object)type)) {
            return this.isGreaterThanOrEqualsTo(this.getCurrentValue());
        }
        if (CoreFunctionType.BETWEEN.equals((Object)type)) {
            return this.isBetween(this.getCurrentValue());
        }
        if (CoreFunctionType.TIME_FRAME.equals((Object)type)) {
            return this.timeFrame(this.getCurrentValue());
        }
        if (CoreFunctionType.IN.equals((Object)type)) {
            return this.isEqualsTo(this.getCurrentValue());
        }
        if (CoreFunctionType.NOT_IN.equals((Object)type)) {
            return this.isNotEqualsTo(this.getCurrentValue());
        }
        throw new IllegalArgumentException("Core function type not supported: " + type);
    }

    public boolean isNull(Comparable value) {
        return value == null;
    }

    public boolean isNotNull(Comparable value) {
        return !this.isNull(value);
    }

    public boolean compare(Comparable c1, Comparable c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 != null && c2 != null) {
            if (c1 instanceof Number && c2 instanceof Number) {
                return ((Number)((Object)c1)).doubleValue() == ((Number)((Object)c2)).doubleValue();
            }
            return c1.toString().equals(c2.toString());
        }
        return false;
    }

    public boolean isEqualsTo(Comparable value) {
        if (this.getParameters().isEmpty()) {
            return true;
        }
        for (Comparable param : this.getParameters()) {
            if (!this.compare(param, value)) continue;
            return true;
        }
        return false;
    }

    public boolean isNotEqualsTo(Comparable value) {
        if (this.getParameters().isEmpty()) {
            return true;
        }
        return !this.isEqualsTo(value);
    }

    public boolean isLikeTo(Comparable value) {
        if (value == null) {
            return false;
        }
        Comparable param0 = this.getParameter(0);
        if (param0 == null) {
            return false;
        }
        Boolean caseSensitive = this.getParameter(1) != null ? Boolean.parseBoolean(this.getParameter(1).toString()) : true;
        String pattern = caseSensitive != false ? param0.toString() : param0.toString().toLowerCase();
        String strValue = caseSensitive != false ? value.toString() : value.toString().toLowerCase();
        pattern = pattern.replace(".", "\\.");
        pattern = pattern.replace("%", ".*");
        pattern = pattern.replace("_", ".");
        return strValue.matches(pattern);
    }

    public boolean isLowerThan(Comparable value) {
        return !this.isGreaterThanOrEqualsTo(value);
    }

    public boolean isLowerThanOrEqualsTo(Comparable value) {
        return !this.isGreaterThan(value);
    }

    public boolean isGreaterThan(Comparable value) {
        if (value == null) {
            return false;
        }
        Comparable ref = this.getParameter(0);
        return ref == null || value.compareTo(ref) == 1;
    }

    public boolean isGreaterThanOrEqualsTo(Comparable value) {
        Comparable ref = this.getParameter(0);
        if (ref == null) {
            return true;
        }
        return value != null && value.compareTo(ref) != -1;
    }

    public boolean isBetween(Comparable value) {
        Comparable low = this.getParameter(0);
        Comparable high = this.getParameter(1);
        if (value == null) {
            return low == null;
        }
        if (low != null && value.compareTo(low) == -1) {
            return false;
        }
        return high == null || value.compareTo(high) != 1;
    }

    public boolean timeFrame(Comparable value) {
        String timeFrameExpr = this.getParameter(0).toString();
        if (timeFrameExpr == null || value == null) {
            return false;
        }
        if (!(value instanceof Date)) {
            return false;
        }
        Date target = (Date)value;
        TimeFrameLimits timeFrameLimits = this._timeFrameExprCache.get(timeFrameExpr);
        if (timeFrameLimits == null) {
            TimeFrame timeFrame = TimeFrame.parse((String)this.getParameter(0).toString());
            timeFrameLimits = new TimeFrameLimits(timeFrame);
            this._timeFrameExprCache.put(timeFrameExpr, timeFrameLimits);
        }
        if (target.before(timeFrameLimits.from)) {
            return false;
        }
        return !target.after(timeFrameLimits.to);
    }

    public class TimeFrameLimits {
        Date from = null;
        Date to = null;

        public TimeFrameLimits(TimeFrame timeFrame) {
            this.from = timeFrame.getFrom().getTimeInstant();
            this.to = timeFrame.getTo().getTimeInstant();
        }
    }
}

