/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.backend.server;

import java.io.IOException;
import java.text.MessageFormat;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.kie.server.api.model.instance.DocumentInstance;
import org.kie.server.client.DocumentServicesClient;
import org.kie.server.client.KieServicesClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.server.util.FileServletUtil;

@WebServlet(name="ProcessDocumentServlet", urlPatterns={"/jbpm/documents"})
public class ProcessDocumentServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDocumentServlet.class);
    public static final String ERROR_RETRIEVING_DOC = "Error occured during document retrieval \"{0}\".";
    public static final String INVALID_SERVICES_CLIENT = "Unable to retrieve services client with template id \"{0}\"";
    public static final String INVALID_DOCUMENT = "Unable to retrieve document with id \"{0}\"";
    public static final String INVALID_PARAMS = "Invalid parameters to servlet: templateid: \"{0}\", docid: \"{1}\"";
    @Inject
    private KieServerIntegration kieServerIntegration;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block6: {
            try {
                String templateId = FileServletUtil.encodeFileNamePart((String)request.getParameter("templateid"));
                String docId = FileServletUtil.encodeFileNamePart((String)request.getParameter("docid"));
                if (templateId == null || docId == null) {
                    logger.error(MessageFormat.format(INVALID_PARAMS, templateId, docId));
                    return;
                }
                KieServicesClient kieServicesClient = this.kieServerIntegration.getServerClient(templateId);
                if (kieServicesClient != null) {
                    DocumentServicesClient documentServicesClient = (DocumentServicesClient)kieServicesClient.getServicesClient(DocumentServicesClient.class);
                    DocumentInstance documentInstance = documentServicesClient.getDocument(docId);
                    if (documentInstance != null) {
                        response.setContentType("application/octet-stream");
                        response.setHeader("Content-Disposition", "attachment; filename=\"" + documentInstance.getName() + "\"");
                        response.getOutputStream().write(documentInstance.getContent());
                    } else {
                        logger.error(MessageFormat.format(INVALID_DOCUMENT, docId));
                    }
                    break block6;
                }
                logger.error(MessageFormat.format(INVALID_SERVICES_CLIENT, templateId));
                return;
            }
            catch (Exception e) {
                logger.error(MessageFormat.format(ERROR_RETRIEVING_DOC, e.getMessage()));
                return;
            }
        }
    }

    public void setKieServerIntegration(KieServerIntegration kieServerIntegration) {
        this.kieServerIntegration = kieServerIntegration;
    }
}

