/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime;

import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.drools.core.command.IdentifiableResult;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.command.RegistryContext;

@XmlRootElement(name="advance-session-time")
@XmlAccessorType(value=XmlAccessType.NONE)
public class AdvanceSessionTimeCommand
implements ExecutableCommand<Long>,
IdentifiableResult {
    private static final long serialVersionUID = 510L;
    @XmlAttribute(name="out-identifier", required=true)
    private String outIdentifier;
    @XmlAttribute(name="amount")
    private long amount;
    @XmlAttribute(name="unit")
    private TimeUnit unit;

    public AdvanceSessionTimeCommand() {
        this("session-advancecurrenttime", 0L, TimeUnit.MILLISECONDS);
    }

    public AdvanceSessionTimeCommand(long amount, TimeUnit unit) {
        this("session-advancecurrenttime", amount, unit);
    }

    public AdvanceSessionTimeCommand(String outIdentifier, long amount, TimeUnit unit) {
        this.outIdentifier = outIdentifier;
        this.amount = amount;
        this.unit = unit;
    }

    public Long execute(Context context) {
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        SessionPseudoClock sessionClock = (SessionPseudoClock)ksession.getSessionClock();
        sessionClock.advanceTime(this.amount, this.unit);
        long result = sessionClock.getCurrentTime();
        ExecutionResultImpl results = (ExecutionResultImpl)((RegistryContext)context).lookup(ExecutionResultImpl.class);
        if (results != null) {
            results.getResults().put(this.outIdentifier, result);
        }
        return result;
    }

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public String toString() {
        return "session.getSessionClock().advanceTime( " + this.amount + ", " + (Object)((Object)this.unit) + " );";
    }
}

