/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.util;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiIndexerLock {
    private final ReentrantLock resourceLock;
    private final AtomicReference<String> indexerId = new AtomicReference();
    private static final Logger logger = LoggerFactory.getLogger(MultiIndexerLock.class);

    public MultiIndexerLock(ReentrantLock globalLock) {
        this.resourceLock = globalLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String indexerId) {
        logger.debug("Attempting to get lock for indexer [{}].", (Object)indexerId);
        this.resourceLock.lock();
        logger.trace("Acquired global lock. Attempting to acquire internal lock to update locked indexer id.");
        MultiIndexerLock multiIndexerLock = this;
        synchronized (multiIndexerLock) {
            logger.trace("Acquired internal lock. Updating locked indexer id to [{}].", (Object)indexerId);
            this.indexerId.set(indexerId);
            this.notifyAll();
            logger.debug("Finished acquiring lock for indexer [{}].", (Object)indexerId);
        }
    }

    public synchronized boolean isLockedBy(String indexerId) {
        boolean result;
        boolean isGloballyLocked;
        logger.debug("Checking if locked by indexer [{}].", (Object)indexerId);
        String lockedIndexerId = null;
        while ((isGloballyLocked = this.resourceLock.isLocked()) && (lockedIndexerId = this.indexerId.get()) == null) {
            try {
                logger.trace("Lock acquisition in progress. Waiting to be notified.");
                this.wait();
            }
            catch (InterruptedException ignore) {
                logger.trace("InterruptedException while waiting to be notified.");
            }
        }
        if (logger.isTraceEnabled()) {
            String logMessageVerb = isGloballyLocked ? "is" : "is not";
            logger.trace("Finished waiting for notification. Global lock {} held. Locked indexer id is [{}].", (Object)logMessageVerb, (Object)lockedIndexerId);
        }
        boolean bl = result = isGloballyLocked && Objects.equals(lockedIndexerId, indexerId);
        if (logger.isDebugEnabled()) {
            logger.debug("Lock {} held by indexer [{}].", (Object)(result ? "is" : "is not"), (Object)indexerId);
        }
        return result;
    }

    public synchronized void unlock(String indexerId) {
        logger.debug("Attempting to relinquish lock for indexer [{}].", (Object)indexerId);
        String lockedId = this.indexerId.get();
        if (lockedId == null || !lockedId.equals(indexerId)) {
            throw new IllegalArgumentException(String.format("Cannot unlock for indexer [%s] because that indexer does not hold the lock. This thread holds the lock for indexer [%s].", indexerId, lockedId));
        }
        if (!this.resourceLock.isHeldByCurrentThread()) {
            throw new IllegalArgumentException("This thread does not hold the lock.");
        }
        this.indexerId.set(null);
        this.resourceLock.unlock();
        logger.debug("Successfully relinquished lock for indexer [{}].", (Object)indexerId);
    }
}

