/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.commons.rendering.shared.util.masks;

import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.common.client.api.Assert;
import org.kie.workbench.common.forms.commons.rendering.shared.util.masks.MaskSection;
import org.kie.workbench.common.forms.commons.rendering.shared.util.masks.MaskSectionType;
import org.kie.workbench.common.forms.commons.rendering.shared.util.masks.ModelInterpreter;

public abstract class MaskInterpreter<T> {
    protected List<MaskSection> sections = new ArrayList<MaskSection>();
    protected String mask;

    public MaskInterpreter(String mask) {
        Assert.notNull((String)"Mask cannot be null!", (Object)mask);
        this.mask = mask;
        if (this.isValid(mask)) {
            while (mask.contains("{") && mask.contains("}")) {
                int open = mask.indexOf("{");
                int close = mask.indexOf("}");
                String text = mask.substring(0, open);
                String property = mask.substring(open + 1, close);
                if (!text.isEmpty()) {
                    this.sections.add(new MaskSectionImpl(MaskSectionType.LITERAL, text));
                }
                this.sections.add(new MaskSectionImpl(MaskSectionType.PROPERTY, property));
                mask = mask.substring(close + 1);
            }
            if (!mask.isEmpty()) {
                this.sections.add(new MaskSectionImpl(MaskSectionType.LITERAL, mask));
            }
        } else {
            throw new IllegalArgumentException("Invalid mask!");
        }
    }

    protected boolean isValid(String mask) {
        if (mask == null) {
            return false;
        }
        if (mask.isEmpty()) {
            return true;
        }
        int countOpeners = 0;
        int countClosers = 0;
        for (char c : mask.toCharArray()) {
            if (c == '{') {
                ++countOpeners;
                continue;
            }
            if (c != '}') continue;
            ++countClosers;
        }
        return countOpeners != 0 && countOpeners == countClosers;
    }

    public String render(T model) {
        if (model == null) {
            return "";
        }
        if (this.sections.isEmpty()) {
            return model.toString();
        }
        ModelInterpreter<T> interpreter = this.getModelInterpreter(model);
        String result = "";
        for (MaskSection section : this.sections) {
            String value = section.getText();
            if (section.getType().equals((Object)MaskSectionType.PROPERTY)) {
                String propertyValue = interpreter.getPropertyValue(section.getText());
                value = propertyValue != null ? propertyValue.toString() : "";
            }
            result = result + value;
        }
        return result;
    }

    protected abstract ModelInterpreter<T> getModelInterpreter(T var1);

    public List<MaskSection> getSections() {
        return this.sections;
    }

    public String getMask() {
        return this.mask;
    }

    private class MaskSectionImpl
    implements MaskSection {
        private MaskSectionType type;
        private String text;

        public MaskSectionImpl(MaskSectionType type, String text) {
            this.type = type;
            this.text = text;
        }

        @Override
        public MaskSectionType getType() {
            return this.type;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }
}

