/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.internal;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.client.OpenShiftConfig;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OpenShiftOAuthInterceptor
implements Interceptor {
    private static final String AUTHORIZATION = "Authorization";
    private static final String LOCATION = "Location";
    private static final String AUTHORIZATION_SERVER_PATH = ".well-known/oauth-authorization-server";
    private static final String AUTHORIZE_QUERY = "?response_type=token&client_id=openshift-challenging-client";
    private static final String BEFORE_TOKEN = "access_token=";
    private static final String AFTER_TOKEN = "&expires";
    private final OkHttpClient client;
    private final OpenShiftConfig config;
    private final AtomicReference<String> oauthToken = new AtomicReference();

    public OpenShiftOAuthInterceptor(OkHttpClient client, OpenShiftConfig config) {
        this.client = client;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        String token = this.oauthToken.get();
        if (Utils.isNotNullOrEmpty((String)token) && Utils.isNullOrEmpty((String)request.header(AUTHORIZATION))) {
            this.setAuthHeader(builder, token);
        }
        if ((response = chain.proceed(request = builder.build())).code() != 401 && response.code() != 403) {
            return response;
        }
        if (Utils.isNotNullOrEmpty((String)this.config.getUsername()) && Utils.isNotNullOrEmpty((String)this.config.getPassword())) {
            OkHttpClient okHttpClient = this.client;
            synchronized (okHttpClient) {
                this.oauthToken.set(null);
                token = this.authorize();
                if (token != null) {
                    this.oauthToken.set(token);
                }
            }
        } else if (Utils.isNotNullOrEmpty((String)this.config.getOauthToken())) {
            token = this.config.getOauthToken();
            this.oauthToken.set(token);
        }
        if (Utils.isNotNullOrEmpty((String)token)) {
            response.body().close();
            this.setAuthHeader(builder, token);
            request = builder.build();
            return chain.proceed(request);
        }
        return response;
    }

    private void setAuthHeader(Request.Builder builder, String token) {
        if (token != null) {
            builder.header(AUTHORIZATION, String.format("Bearer %s", token));
        }
    }

    private String authorize() {
        try {
            OkHttpClient.Builder builder = this.client.newBuilder();
            builder.interceptors().remove(this);
            OkHttpClient clone = builder.build();
            URL url = new URL(URLUtils.join((String[])new String[]{this.config.getMasterUrl(), AUTHORIZATION_SERVER_PATH}));
            Response response = clone.newCall(new Request.Builder().get().url(url).build()).execute();
            if (!response.isSuccessful() || response.body() == null) {
                throw new KubernetesClientException("Unexpected response (" + response.code() + " " + response.message() + ")");
            }
            String body = response.body().string();
            JsonNode jsonResponse = Serialization.jsonMapper().readTree(body);
            String authorizationServer = jsonResponse.get("authorization_endpoint").asText();
            response.close();
            url = new URL(authorizationServer + AUTHORIZE_QUERY);
            String credential = Credentials.basic((String)this.config.getUsername(), (String)this.config.getPassword());
            response = clone.newCall(new Request.Builder().get().url(url).header(AUTHORIZATION, credential).build()).execute();
            response.close();
            response = response.priorResponse() != null ? response.priorResponse() : response;
            response = response.networkResponse() != null ? response.networkResponse() : response;
            String token = response.header(LOCATION);
            if (token == null || token.isEmpty()) {
                throw new KubernetesClientException("Unexpected response (" + response.code() + " " + response.message() + "), to the authorization request. Missing header:[" + LOCATION + "]!");
            }
            token = token.substring(token.indexOf(BEFORE_TOKEN) + BEFORE_TOKEN.length());
            token = token.substring(0, token.indexOf(AFTER_TOKEN));
            return token;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }
}

