/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.dynamic.service.shared.adf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.forms.adf.engine.shared.FormBuildingService;
import org.kie.workbench.common.forms.adf.engine.shared.FormElementFilter;
import org.kie.workbench.common.forms.adf.engine.shared.formGeneration.util.PropertyValueExtractor;
import org.kie.workbench.common.forms.dynamic.service.shared.impl.StaticModelFormRenderingContext;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.EntityRelationField;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.HasNestedForm;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.IsCRUDDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.relations.TableColumnMeta;
import org.kie.workbench.common.forms.model.FormDefinition;

@Dependent
public class DynamicFormModelGenerator {
    private FormBuildingService formBuildingService;
    private PropertyValueExtractor propertyValueExtractor;

    @Inject
    public DynamicFormModelGenerator(FormBuildingService formBuildingService, PropertyValueExtractor propertyValueExtractor) {
        this.formBuildingService = formBuildingService;
        this.propertyValueExtractor = propertyValueExtractor;
    }

    public StaticModelFormRenderingContext getContextForModel(Object model, FormElementFilter ... filters) {
        PortablePreconditions.checkNotNull((String)"model", (Object)model);
        Optional<FormElementFilter[]> optional = Optional.ofNullable(filters);
        Stream streamFilter = optional.map(value -> Stream.of(value)).orElseGet(Stream::empty);
        ArrayList rootFormElemenFilters = new ArrayList();
        ArrayList<FormElementFilter> nestedFormFilters = new ArrayList<FormElementFilter>();
        streamFilter.forEach(filter -> {
            if (!filter.getElementName().contains(".")) {
                rootFormElemenFilters.add(filter);
            } else {
                nestedFormFilters.add((FormElementFilter)filter);
            }
        });
        FormDefinition formDefinition = this.formBuildingService.generateFormForModel(model, (FormElementFilter[])rootFormElemenFilters.stream().toArray(FormElementFilter[]::new));
        if (formDefinition == null) {
            return null;
        }
        StaticModelFormRenderingContext context = new StaticModelFormRenderingContext(String.valueOf(System.currentTimeMillis()));
        context.setModel(model);
        context.setRootForm(formDefinition);
        if (context.getModel() != null) {
            this.initNestedFormSettings(formDefinition, context.getModel(), context, nestedFormFilters);
        } else {
            this.initNestedFormSettings(formDefinition, null, context, nestedFormFilters);
        }
        return context;
    }

    private void initNestedFormSettings(FormDefinition form, Object model, StaticModelFormRenderingContext context, Collection<FormElementFilter> nestedFormFilters) {
        form.getFields().forEach(field -> {
            if (field instanceof HasNestedForm) {
                HasNestedForm hasNestedForm = (HasNestedForm)field;
                if (!context.getAvailableForms().containsKey(((HasNestedForm)field).getNestedForm())) {
                    this.addNestedForm(model, hasNestedForm.getNestedForm(), field.getName(), context, this.getNestedFiltersStream(field.getName(), nestedFormFilters));
                }
            } else if (field instanceof IsCRUDDefinition) {
                IsCRUDDefinition isCRUDDefinitionField = (IsCRUDDefinition)field;
                if (!context.getAvailableForms().containsKey(isCRUDDefinitionField.getCreationForm())) {
                    this.addNestedForm(field.getStandaloneClassName(), context, this.getNestedFiltersStream(field.getName(), nestedFormFilters));
                }
                if (isCRUDDefinitionField.getColumnMetas() == null || isCRUDDefinitionField.getColumnMetas().isEmpty()) {
                    if (isCRUDDefinitionField.getColumnMetas() == null) {
                        isCRUDDefinitionField.setColumnMetas(new ArrayList());
                    }
                    FormDefinition nestedForm = context.getAvailableForms().get(isCRUDDefinitionField.getCreationForm());
                    nestedForm.getFields().forEach(nestedField -> {
                        if (nestedField instanceof EntityRelationField) {
                            return;
                        }
                        isCRUDDefinitionField.getColumnMetas().add(new TableColumnMeta(nestedField.getLabel(), nestedField.getBinding()));
                    });
                }
            }
        });
    }

    private Collection<FormElementFilter> getNestedFiltersStream(String name, Collection<FormElementFilter> filterStream) {
        return filterStream.stream().filter(filter -> filter.getElementName().startsWith(name + ".")).map(filter -> {
            String elementName = filter.getElementName().substring(name.length() + 1);
            return new FormElementFilter(elementName, filter.getPredicate());
        }).collect(Collectors.toList());
    }

    private void addNestedForm(Object parentModel, String className, String fieldName, StaticModelFormRenderingContext context, Collection<FormElementFilter> nestedElementFilters) {
        if (!context.getAvailableForms().containsKey(className)) {
            if (parentModel != null) {
                Object value = this.propertyValueExtractor.readPropertyValue(parentModel, fieldName);
                if (value != null) {
                    this.addNestedForm(value, context, nestedElementFilters);
                } else {
                    this.addNestedForm(className, context, nestedElementFilters);
                }
            } else {
                this.addNestedForm(className, context, nestedElementFilters);
            }
        }
    }

    private void addNestedForm(String className, StaticModelFormRenderingContext context, Collection<FormElementFilter> nestedFormFilters) {
        if (!context.getAvailableForms().containsKey(className)) {
            FormDefinition nested = this.formBuildingService.generateFormForClassName(className, (FormElementFilter[])nestedFormFilters.stream().toArray(FormElementFilter[]::new));
            context.getAvailableForms().put(className, nested);
            this.initNestedFormSettings(nested, null, context, nestedFormFilters);
        }
    }

    private void addNestedForm(Object model, StaticModelFormRenderingContext context, Collection<FormElementFilter> nestedFormFilters) {
        if (!context.getAvailableForms().containsKey(model.getClass().getName())) {
            FormDefinition nested = this.formBuildingService.generateFormForModel(model, (FormElementFilter[])nestedFormFilters.stream().toArray(FormElementFilter[]::new));
            context.getAvailableForms().put(model.getClass().getName(), nested);
            this.initNestedFormSettings(nested, model, context, nestedFormFilters);
        }
    }
}

