/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.HashMap;
import java.util.Map;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.Permission;

public class DefaultAuthzResultCache {
    final Map<Permission, Map<String, AuthorizationResult>> internal = new HashMap<Permission, Map<String, AuthorizationResult>>();

    public AuthorizationResult get(User user, Permission permission) {
        Map<String, AuthorizationResult> result = this.internal.get(permission);
        if (result == null) {
            return null;
        }
        return result.get(user.getIdentifier());
    }

    public void put(User user, Permission permission, AuthorizationResult authzResult) {
        if (!this.internal.containsKey(permission)) {
            this.internal.put(permission, new HashMap());
        }
        Map<String, AuthorizationResult> result = this.internal.get(permission);
        AuthorizationResult knowValue = result.get(user.getIdentifier());
        if (!result.containsKey(user.getIdentifier()) || !authzResult.equals((Object)knowValue)) {
            result.put(user.getIdentifier(), authzResult);
        }
    }

    public int size(User user) {
        int count = 0;
        for (Map<String, AuthorizationResult> userCache : this.internal.values()) {
            if (!userCache.containsKey(user.getIdentifier())) continue;
            ++count;
        }
        return count;
    }

    public void clear() {
        this.internal.clear();
    }

    public void invalidate(User user) {
        if (user == null || user.getIdentifier() == null || user.getIdentifier().isEmpty()) {
            return;
        }
        for (Map<String, AuthorizationResult> entry : this.internal.values()) {
            entry.remove(user.getIdentifier());
        }
    }
}

