/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodel.backend.server.builder.util;

import java.lang.annotation.Inherited;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.errai.config.rebind.EnvUtil;
import org.kie.soup.project.datamodel.oracle.Annotation;

public class AnnotationUtils {
    public static Object getAnnotationAttributeValue(java.lang.annotation.Annotation annotation, String attributeName) {
        Object value = null;
        if (annotation != null) {
            try {
                Class<?> portableType;
                value = annotation.annotationType().getMethod(attributeName, new Class[0]).invoke((Object)annotation, new Object[0]);
                Class<?> valueType = value.getClass();
                Class<?> componentType = valueType.getComponentType();
                Class<?> clazz = portableType = componentType != null ? componentType : valueType;
                if (!EnvUtil.isPortableType(portableType)) {
                    value = value.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public static Set<Annotation> getClassAnnotations(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        return AnnotationUtils.getAnnotations(clazz.getAnnotations(), false);
    }

    public static Set<Annotation> getFieldAnnotations(Field field) {
        return AnnotationUtils.getFieldAnnotations(field, false);
    }

    public static Set<Annotation> getFieldAnnotations(Field field, boolean inherited) {
        if (field == null) {
            return Collections.emptySet();
        }
        return AnnotationUtils.getAnnotations(field.getDeclaredAnnotations(), inherited);
    }

    private static Set<Annotation> getAnnotations(java.lang.annotation.Annotation[] annotations, boolean checkInheritance) {
        LinkedHashSet<Annotation> fieldAnnotations = new LinkedHashSet<Annotation>();
        for (java.lang.annotation.Annotation a : annotations) {
            if (checkInheritance && !a.annotationType().isAnnotationPresent(Inherited.class)) continue;
            Annotation fieldAnnotation = new Annotation(a.annotationType().getName());
            for (Method m : a.annotationType().getDeclaredMethods()) {
                String methodName = m.getName();
                fieldAnnotation.addParameter(methodName, AnnotationUtils.getAnnotationAttributeValue(a, methodName));
            }
            fieldAnnotations.add(fieldAnnotation);
        }
        return fieldAnnotations;
    }
}

