/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.storage.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefinition;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.storage.ExperimentalFeaturesStorage;
import org.uberfire.experimental.service.storage.migration.StorageMigrationService;
import org.uberfire.experimental.service.storage.scoped.ExperimentalStorageScope;
import org.uberfire.experimental.service.storage.scoped.ScopedExperimentalFeaturesStorage;
import org.uberfire.experimental.service.storage.util.ExperimentalConstants;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.spaces.SpacesAPI;

@Named(value="global")
public class ExperimentalFeaturesStorageImpl
implements ExperimentalFeaturesStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExperimentalFeaturesStorageImpl.class);
    private Properties settings;
    private FileSystem fileSystem;
    private Map<ExperimentalStorageScope, ScopedExperimentalFeaturesStorage> storages = new HashMap<ExperimentalStorageScope, ScopedExperimentalFeaturesStorage>();
    private SpacesAPI spaces;
    private IOService ioService;
    private ExperimentalFeatureDefRegistry defRegistry;
    private Instance<ScopedExperimentalFeaturesStorage> instances;
    private StorageMigrationService migrationService;

    @Inject
    public ExperimentalFeaturesStorageImpl(SpacesAPI spaces, @Named(value="configIO") IOService ioService, ExperimentalFeatureDefRegistry defRegistry, Instance<ScopedExperimentalFeaturesStorage> instances, StorageMigrationService migrationService) {
        this.spaces = spaces;
        this.ioService = ioService;
        this.defRegistry = defRegistry;
        this.instances = instances;
        this.migrationService = migrationService;
    }

    @PostConstruct
    public void init() {
        this.initializeFileSystem();
        for (ScopedExperimentalFeaturesStorage storage : this.instances) {
            storage.init(this.fileSystem);
            this.storages.put(storage.getScope(), storage);
        }
        this.readSettings();
        this.checkVersion();
    }

    private void readSettings() {
        Path settingsPath = this.fileSystem.getPath("/experimental/.settings", new String[0]);
        if (this.ioService.exists(settingsPath)) {
            this.settings = new Properties();
            try (InputStream in = this.ioService.newInputStream(settingsPath, new OpenOption[0]);){
                this.settings.load(in);
            }
            catch (Exception e) {
                LOGGER.error("Couldn't read properties file");
            }
        } else {
            this.settings = new Properties();
        }
    }

    private void checkVersion() {
        int currentVersion = Integer.parseInt(this.settings.getOrDefault((Object)"version", "1").toString());
        if (currentVersion < ExperimentalConstants.EXPERIMENTAL_VERSION) {
            this.migrationService.migrate(ExperimentalConstants.EXPERIMENTAL_VERSION, this.fileSystem);
            this.settings.setProperty("version", ExperimentalConstants.EXPERIMENTAL_VERSION.toString());
            this.saveSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSettings() {
        Path settingsPath = this.fileSystem.getPath("/experimental/.settings", new String[0]);
        try (OutputStream out = this.ioService.newOutputStream(settingsPath, new OpenOption[0]);){
            this.ioService.startBatch(this.fileSystem);
            this.settings.store(out, "Updating experimental features registry");
        }
        catch (Exception ex) {
            LOGGER.warn("Impossible to write experimental features registry on '{}': {}", (Object)settingsPath, (Object)ex);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    @Override
    public Collection<ExperimentalFeatureImpl> getFeatures() {
        ArrayList<ExperimentalFeatureImpl> features = new ArrayList<ExperimentalFeatureImpl>();
        this.storages.values().forEach(storage -> features.addAll(storage.getFeatures()));
        return features;
    }

    @Override
    public void store(ExperimentalFeatureImpl experimentalFeature) {
        Optional<ExperimentalFeatureDefinition> optional = Optional.ofNullable(this.defRegistry.getFeatureById(experimentalFeature.getFeatureId()));
        optional.ifPresent(definition -> this.storages.get((Object)ExperimentalStorageScope.getScope(definition)).store(experimentalFeature));
    }

    protected void initializeFileSystem() {
        URI fileSystemURI = this.spaces.resolveFileSystemURI(SpacesAPI.Scheme.DEFAULT, SpacesAPI.DEFAULT_SPACE, "preferences");
        try {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("init", Boolean.TRUE);
            options.put("internal", Boolean.TRUE);
            this.fileSystem = this.ioService.newFileSystem(fileSystemURI, options);
        }
        catch (FileSystemAlreadyExistsException e) {
            this.fileSystem = this.ioService.getFileSystem(fileSystemURI);
        }
    }
}

