/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerStateInfo;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.ModelFactory;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.service.LoggingNotificationService;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KieServerControllerImpl
implements KieServerController {
    private static final Logger logger = LoggerFactory.getLogger(KieServerControllerImpl.class);
    private KieServerTemplateStorage templateStorage = InMemoryKieServerTemplateStorage.getInstance();
    private NotificationService notificationService = LoggingNotificationService.getInstance();

    public synchronized KieServerSetup connect(KieServerInfo serverInfo) {
        boolean isKieServerLocationAvailable = this.isKieServerLocationAvailable(serverInfo);
        String serverId = serverInfo.getServerId();
        ServerTemplate serverTemplate = this.templateStorage.load(serverId);
        KieServerSetup serverSetup = new KieServerSetup();
        ServerInstanceKey serverInstanceKey = null;
        if (isKieServerLocationAvailable) {
            if (serverTemplate == null || serverTemplate.getServerInstance(serverId) == null) {
                logger.warn("Trying to connect a detached or undefined KIE server: {} is not supported.", (Object)serverId);
                return serverSetup;
            }
            serverInstanceKey = serverTemplate.getServerInstance(serverId);
            serverInfo.setLocation(serverInstanceKey.getUrl());
        } else {
            serverInstanceKey = ModelFactory.newServerInstanceKey((String)serverInfo.getServerId(), (String)serverInfo.getLocation());
        }
        if (serverTemplate != null) {
            if (!this.checkValidServerInstance(serverTemplate, serverInfo, serverSetup)) {
                return serverSetup;
            }
            logger.debug("Server id {} know to the controller, checking if given server exists", (Object)serverInfo.getServerId());
            if (!serverTemplate.hasServerInstance(serverInfo.getLocation())) {
                logger.debug("Server instance '{}' not yet registered", (Object)serverInfo.getLocation());
                serverTemplate.addServerInstance(serverInstanceKey);
            }
            if (!isKieServerLocationAvailable) {
                this.templateStorage.update(serverTemplate);
                logger.debug("KieServerInstance updated after connect from server {}", (Object)serverInfo.getLocation());
            }
            serverSetup = this.toKieServerSetup(serverTemplate);
        } else {
            logger.debug("Server id {} unknown to this controller, registering...", (Object)serverInfo.getServerId());
            serverTemplate = new ServerTemplate();
            serverTemplate.setId(serverInfo.getServerId());
            serverTemplate.setName(serverInfo.getName());
            ArrayList<String> capabilities = new ArrayList<String>();
            if (serverInfo.getCapabilities() != null) {
                for (String serverCapability : serverInfo.getCapabilities()) {
                    if (KieServerControllerImpl.getCompatibleServerTemplateCapability(serverCapability) == null) continue;
                    capabilities.add(KieServerControllerImpl.getCompatibleServerTemplateCapability(serverCapability));
                }
            }
            serverTemplate.setCapabilities(capabilities);
            serverTemplate.setMode(serverInfo.getMode());
            serverTemplate.addServerInstance(serverInstanceKey);
            logger.debug("KieServerInstance stored after connect (register) from server {}", (Object)serverInfo.getLocation());
            this.templateStorage.store(serverTemplate);
            this.notificationService.notify(new ServerTemplateUpdated(serverTemplate));
        }
        logger.info("Server {} connected to controller", (Object)serverInfo.getLocation());
        ArrayList<Container> containerList = new ArrayList<Container>();
        for (ContainerSpec containerSpec : serverTemplate.getContainersSpec()) {
            containerList.add(new Container(containerSpec.getId(), containerSpec.getContainerName(), serverInstanceKey, new ArrayList(), containerSpec.getReleasedId(), serverInstanceKey.getUrl() + "/containers/" + containerSpec.getId()));
        }
        ServerInstance serverInstance = new ServerInstance();
        serverInstance.setServerName(serverInstanceKey.getServerName());
        serverInstance.setServerTemplateId(serverInstanceKey.getServerTemplateId());
        serverInstance.setServerInstanceId(serverInstanceKey.getServerInstanceId());
        serverInstance.setUrl(serverInstanceKey.getUrl());
        serverInstance.setContainers(containerList);
        this.notifyOnConnect(serverInstance);
        return serverSetup;
    }

    public KieServerSetup update(KieServerStateInfo kieServerStateInfo) {
        String serverId = kieServerStateInfo.getServerId();
        ServerTemplate serverTemplate = this.templateStorage.load(serverId);
        ServerInstanceKey serverInstanceKey = ModelFactory.newServerInstanceKey((String)kieServerStateInfo.getServerId(), (String)kieServerStateInfo.getLocation());
        if (serverTemplate == null) {
            logger.info("Server id {} unknown to this controller, state update will create the template", (Object)kieServerStateInfo.getServerId());
            return new KieServerSetup();
        }
        ArrayList<Container> containerList = new ArrayList<Container>();
        List<KieContainerStatus> invalidStatus = Collections.singletonList(KieContainerStatus.STOPPED);
        for (ContainerSpec containerSpec : serverTemplate.getContainersSpec()) {
            if (invalidStatus.contains(containerSpec.getStatus())) continue;
            Container container = new Container(containerSpec.getId(), containerSpec.getContainerName(), serverInstanceKey, new ArrayList(), containerSpec.getReleasedId(), serverInstanceKey.getUrl() + "/containers/" + containerSpec.getId());
            container.setStatus(containerSpec.getStatus());
            containerList.add(container);
        }
        ServerInstance serverInstance = new ServerInstance();
        serverInstance.setServerName(serverInstanceKey.getServerName());
        serverInstance.setServerTemplateId(serverInstanceKey.getServerTemplateId());
        serverInstance.setServerInstanceId(serverInstanceKey.getServerInstanceId());
        serverInstance.setUrl(serverInstanceKey.getUrl());
        serverInstance.setContainers(containerList);
        this.notificationService.notify(new ServerInstanceUpdated(serverInstance));
        this.notificationService.notify(new ServerTemplateUpdated(serverTemplate));
        for (ContainerSpec currentSpec : serverTemplate.getContainersSpec()) {
            ArrayList<Container> specContainerList = new ArrayList<Container>();
            for (ServerInstanceKey currentServerInstanceKey : serverTemplate.getServerInstanceKeys()) {
                Container container = new Container(currentSpec.getId(), currentSpec.getContainerName(), currentServerInstanceKey, new ArrayList(), currentSpec.getReleasedId(), currentServerInstanceKey.getUrl() + "/containers/" + currentSpec.getId());
                container.setStatus(currentSpec.getStatus());
                specContainerList.add(container);
            }
            this.notificationService.notify(serverTemplate, currentSpec, specContainerList);
        }
        return this.toKieServerSetup(serverTemplate);
    }

    private KieServerSetup toKieServerSetup(ServerTemplate serverTemplate) {
        KieServerSetup serverSetup = new KieServerSetup();
        HashSet<KieContainerResource> containers = new HashSet<KieContainerResource>();
        for (ContainerSpec containerSpec : serverTemplate.getContainersSpec()) {
            KieContainerResource containerResource = new KieContainerResource();
            containerResource.setContainerId(containerSpec.getId());
            containerResource.setContainerAlias(containerSpec.getContainerName());
            containerResource.setReleaseId(containerSpec.getReleasedId());
            containerResource.setStatus(containerSpec.getStatus());
            ContainerConfig containerConfig = (ContainerConfig)containerSpec.getConfigs().get(Capability.RULE);
            if (containerConfig != null) {
                RuleConfig ruleConfig = (RuleConfig)containerConfig;
                KieScannerResource scannerResource = new KieScannerResource();
                scannerResource.setPollInterval(ruleConfig.getPollInterval());
                scannerResource.setStatus(ruleConfig.getScannerStatus());
                containerResource.setScanner(scannerResource);
            }
            if ((containerConfig = (ContainerConfig)containerSpec.getConfigs().get(Capability.PROCESS)) != null) {
                ProcessConfig processConfig = (ProcessConfig)containerConfig;
                this.computeProcessConfigItems(processConfig).forEach(e -> containerResource.addConfigItem(e));
            }
            containers.add(containerResource);
        }
        serverSetup.setContainers(containers);
        KieServerConfig serverConfig = new KieServerConfig();
        for (Map.Entry entry : serverTemplate.getConfigs().entrySet()) {
            KieServerConfigItem configItem = new KieServerConfigItem();
            configItem.setType(((Capability)entry.getKey()).toString());
            serverConfig.addConfigItem(configItem);
        }
        serverSetup.setServerConfig(serverConfig);
        return serverSetup;
    }

    private List<KieServerConfigItem> computeProcessConfigItems(ProcessConfig processConfig) {
        ArrayList<KieServerConfigItem> items = new ArrayList<KieServerConfigItem>();
        KieServerConfigItem configItem = new KieServerConfigItem();
        configItem.setType("BPM");
        configItem.setName("KBase");
        configItem.setValue(processConfig.getKBase());
        items.add(configItem);
        configItem = new KieServerConfigItem();
        configItem.setType("BPM");
        configItem.setName("KSession");
        configItem.setValue(processConfig.getKSession());
        items.add(configItem);
        configItem = new KieServerConfigItem();
        configItem.setType("BPM");
        configItem.setName("MergeMode");
        configItem.setValue(processConfig.getMergeMode());
        items.add(configItem);
        configItem = new KieServerConfigItem();
        configItem.setType("BPM");
        configItem.setName("RuntimeStrategy");
        configItem.setValue(processConfig.getRuntimeStrategy());
        items.add(configItem);
        return items;
    }

    private boolean isOpenShiftSupported() {
        return "true".equals(System.getProperty("org.kie.server.controller.openshift.enabled", "false"));
    }

    private boolean checkValidServerInstance(ServerTemplate serverTemplate, KieServerInfo serverInfo, KieServerSetup serverSetup) {
        if (this.isOpenShiftSupported()) {
            return serverSetup.hasNoErrors();
        }
        if (serverTemplate.getMode() != null && !serverInfo.getMode().equals((Object)serverTemplate.getMode())) {
            serverSetup.getMessages().add(new Message(Severity.ERROR, "Expected mode was " + serverTemplate.getMode()));
            logger.warn("Server id {} mode expected {} but it was {}", new Object[]{serverInfo.getServerId(), serverTemplate.getMode(), serverInfo.getMode()});
        }
        if (serverTemplate.getCapabilities() != null && !serverTemplate.getCapabilities().isEmpty()) {
            List currentCapabilities = serverInfo.getCapabilities() != null ? serverInfo.getCapabilities() : Collections.emptyList();
            ArrayList expectedCababilities = new ArrayList(serverTemplate.getCapabilities());
            List convertedCurrentCapabilities = currentCapabilities.stream().filter(currentCapability -> KieServerControllerImpl.getCompatibleServerTemplateCapability(currentCapability) != null).map(currentCapability -> KieServerControllerImpl.getCompatibleServerTemplateCapability(currentCapability)).collect(Collectors.toList());
            if (!convertedCurrentCapabilities.containsAll(expectedCababilities)) {
                serverSetup.getMessages().add(new Message(Severity.ERROR, "Expected capabilities were " + serverTemplate.getCapabilities()));
                ArrayList missingCapabilities = expectedCababilities;
                missingCapabilities.removeAll(convertedCurrentCapabilities);
                logger.warn("Server id {} capabilities expected {} but there was missing {}", new Object[]{serverInfo.getServerId(), serverTemplate.getCapabilities(), missingCapabilities});
            }
        }
        return serverSetup.hasNoErrors();
    }

    public synchronized void disconnect(KieServerInfo serverInfo) {
        String id = serverInfo.getServerId();
        ServerTemplate serverTemplate = this.templateStorage.load(id);
        ServerInstanceKey serverInstanceKey = new ServerInstanceKey(id, id, id, "");
        if (serverTemplate != null) {
            logger.debug("Server id {} known to the controller, checking if given server exists", (Object)serverInfo.getServerId());
            if (!this.isKieServerLocationAvailable(serverInfo)) {
                serverInstanceKey = ModelFactory.newServerInstanceKey((String)id, (String)serverInfo.getLocation());
                serverTemplate.deleteServerInstance(serverInstanceKey.getServerInstanceId());
                this.templateStorage.update(serverTemplate);
            }
            logger.info("Server {} disconnected from controller", (Object)serverInstanceKey);
            this.notifyOnDisconnect(serverInstanceKey, serverTemplate);
        }
    }

    private boolean isKieServerLocationAvailable(KieServerInfo serverInfo) {
        return serverInfo.getLocation() == null || serverInfo.getLocation().trim().length() == 0;
    }

    protected void notifyOnConnect(ServerInstance serverInstance) {
        this.notificationService.notify(new ServerInstanceUpdated(serverInstance));
        this.notificationService.notify(new ServerInstanceConnected(serverInstance));
    }

    protected void notifyOnDisconnect(ServerInstanceKey serverInstanceKey, ServerTemplate serverTemplate) {
        this.notificationService.notify(new ServerInstanceDeleted(serverInstanceKey.getServerInstanceId()));
        this.notificationService.notify(new ServerTemplateUpdated(serverTemplate));
        this.notificationService.notify(new ServerInstanceDisconnected(serverInstanceKey.getServerInstanceId()));
    }

    public KieServerTemplateStorage getTemplateStorage() {
        return this.templateStorage;
    }

    public void setTemplateStorage(KieServerTemplateStorage templateStorage) {
        this.templateStorage = templateStorage;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    private static String getCompatibleServerTemplateCapability(String serverInstanceCapability) {
        if (Objects.equals("BRM", serverInstanceCapability)) {
            return Capability.RULE.toString();
        }
        if (Objects.equals("BPM", serverInstanceCapability)) {
            return Capability.PROCESS.toString();
        }
        if (Objects.equals("BRP", serverInstanceCapability)) {
            return Capability.PLANNING.toString();
        }
        return null;
    }
}

