/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;

final class ImportedProtoTypeMetadata
extends ProtoTypeMetadata {
    private final GenericDescriptor descriptor;
    private final BaseMarshaller<?> marshaller;

    ImportedProtoTypeMetadata(GenericDescriptor descriptor, BaseMarshaller<?> marshaller) {
        super(descriptor.getFullName(), marshaller.getJavaClass(), null);
        this.descriptor = descriptor;
        this.marshaller = marshaller;
    }

    @Override
    public boolean isEnum() {
        return this.descriptor instanceof EnumDescriptor;
    }

    @Override
    public ProtoEnumValueMetadata getEnumMemberByName(String name) {
        if (!this.isEnum()) {
            throw new IllegalStateException(this.getFullName() + " is not an enum");
        }
        EnumValueDescriptor evd = ((EnumDescriptor)this.descriptor).findValueByName(name);
        if (evd == null) {
            return null;
        }
        Object ev = ((EnumMarshaller)this.marshaller).decode(evd.getNumber());
        return new ProtoEnumValueMetadata(evd.getNumber(), name, (Enum)ev, null);
    }
}

