/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import io.netty.buffer.ByteBuf;
import java.lang.ref.SoftReference;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.logs.ActiveMQUtilBundle;
import org.apache.activemq.artemis.logs.ActiveMQUtilLogger;

public final class UTF8Util {
    private static final boolean isTrace = ActiveMQUtilLogger.LOGGER.isTraceEnabled();
    private static final ThreadLocal<SoftReference<StringUtilBuffer>> currenBuffer = new ThreadLocal();

    private UTF8Util() {
    }

    public static void writeNullableString(ByteBuf buffer, String val) {
        if (val == null) {
            buffer.writeByte(0);
        } else {
            buffer.writeByte(1);
            UTF8Util.writeString(buffer, val);
        }
    }

    public static void writeString(ByteBuf buffer, String val) {
        int length = val.length();
        buffer.writeInt(length);
        if (length < 9) {
            for (int i = 0; i < val.length(); ++i) {
                buffer.writeShort((int)((short)val.charAt(i)));
            }
        } else if (length < 4095) {
            UTF8Util.saveUTF(buffer, val);
        } else {
            SimpleString.writeSimpleString(buffer, new SimpleString(val));
        }
    }

    public static void saveUTF(ByteBuf out, String str) {
        StringUtilBuffer buffer = UTF8Util.getThreadLocalBuffer();
        if (str.length() > 65535) {
            throw ActiveMQUtilBundle.BUNDLE.stringTooLong(str.length());
        }
        int len = UTF8Util.calculateUTFSize(str, buffer);
        if (len > 65535) {
            throw ActiveMQUtilBundle.BUNDLE.stringTooLong(len);
        }
        out.writeShort((int)((short)len));
        if (len > buffer.byteBuffer.length) {
            buffer.resizeByteBuffer(len);
        }
        if ((long)len == (long)str.length()) {
            for (int byteLocation = 0; byteLocation < len; ++byteLocation) {
                buffer.byteBuffer[byteLocation] = (byte)buffer.charBuffer[byteLocation];
            }
            out.writeBytes(buffer.byteBuffer, 0, len);
        } else {
            if (isTrace) {
                ActiveMQUtilLogger.LOGGER.trace("Saving string with utfSize=" + len + " stringSize=" + str.length());
            }
            int stringLength = str.length();
            int charCount = 0;
            for (int i = 0; i < stringLength; ++i) {
                char charAtPos = buffer.charBuffer[i];
                if (charAtPos >= '\u0001' && charAtPos < '\u007f') {
                    buffer.byteBuffer[charCount++] = (byte)charAtPos;
                    continue;
                }
                if (charAtPos >= '\u0800') {
                    buffer.byteBuffer[charCount++] = (byte)(0xE0 | charAtPos >> 12 & 0xF);
                    buffer.byteBuffer[charCount++] = (byte)(0x80 | charAtPos >> 6 & 0x3F);
                    buffer.byteBuffer[charCount++] = (byte)(0x80 | charAtPos >> 0 & 0x3F);
                    continue;
                }
                buffer.byteBuffer[charCount++] = (byte)(0xC0 | charAtPos >> 6 & 0x1F);
                buffer.byteBuffer[charCount++] = (byte)(0x80 | charAtPos >> 0 & 0x3F);
            }
            out.writeBytes(buffer.byteBuffer, 0, len);
        }
    }

    public static String readUTF(ActiveMQBuffer input) {
        StringUtilBuffer buffer = UTF8Util.getThreadLocalBuffer();
        int size = input.readUnsignedShort();
        if (size > buffer.byteBuffer.length) {
            buffer.resizeByteBuffer(size);
        }
        if (size > buffer.charBuffer.length) {
            buffer.resizeCharBuffer(size);
        }
        if (isTrace) {
            ActiveMQUtilLogger.LOGGER.trace("Reading string with utfSize=" + size);
        }
        int count = 0;
        int charCount = 0;
        input.readBytes(buffer.byteBuffer, 0, size);
        block4: while (count < size) {
            byte byte1;
            if ((byte1 = buffer.byteBuffer[count++]) > 0 && byte1 <= 127) {
                buffer.charBuffer[charCount++] = (char)byte1;
                continue;
            }
            int c = byte1 & 0xFF;
            switch (c >> 4) {
                case 12: 
                case 13: {
                    byte byte2 = buffer.byteBuffer[count++];
                    buffer.charBuffer[charCount++] = (char)((c & 0x1F) << 6 | byte2 & 0x3F);
                    continue block4;
                }
                case 14: {
                    byte byte2 = buffer.byteBuffer[count++];
                    byte byte3 = buffer.byteBuffer[count++];
                    buffer.charBuffer[charCount++] = (char)((c & 0xF) << 12 | (byte2 & 0x3F) << 6 | (byte3 & 0x3F) << 0);
                    continue block4;
                }
            }
            throw new InternalError("unhandled utf8 byte " + c);
        }
        return new String(buffer.charBuffer, 0, charCount);
    }

    public static StringUtilBuffer getThreadLocalBuffer() {
        StringUtilBuffer value;
        SoftReference<StringUtilBuffer> softReference = currenBuffer.get();
        if (softReference == null) {
            value = new StringUtilBuffer();
            softReference = new SoftReference<StringUtilBuffer>(value);
            currenBuffer.set(softReference);
        } else {
            value = softReference.get();
        }
        if (value == null) {
            value = new StringUtilBuffer();
            softReference = new SoftReference<StringUtilBuffer>(value);
            currenBuffer.set(softReference);
        }
        return value;
    }

    public static void clearBuffer() {
        SoftReference<StringUtilBuffer> ref = currenBuffer.get();
        if (ref.get() != null) {
            ref.clear();
        }
    }

    public static int calculateUTFSize(String str, StringUtilBuffer stringBuffer) {
        int calculatedLen = 0;
        int stringLength = str.length();
        if (stringLength > stringBuffer.charBuffer.length) {
            stringBuffer.resizeCharBuffer(stringLength);
        }
        str.getChars(0, stringLength, stringBuffer.charBuffer, 0);
        for (int i = 0; i < stringLength; ++i) {
            char c = stringBuffer.charBuffer[i];
            if (c >= '\u0001' && c < '\u007f') {
                ++calculatedLen;
                continue;
            }
            if (c >= '\u0800') {
                calculatedLen += 3;
                continue;
            }
            calculatedLen += 2;
        }
        return calculatedLen;
    }

    public static class StringUtilBuffer {
        public char[] charBuffer;
        public byte[] byteBuffer;

        public void resizeCharBuffer(int newSize) {
            if (newSize > this.charBuffer.length) {
                this.charBuffer = new char[newSize];
            }
        }

        public void resizeByteBuffer(int newSize) {
            if (newSize > this.byteBuffer.length) {
                this.byteBuffer = new byte[newSize];
            }
        }

        public StringUtilBuffer() {
            this(1024, 1024);
        }

        public StringUtilBuffer(int sizeChar, int sizeByte) {
            this.charBuffer = new char[sizeChar];
            this.byteBuffer = new byte[sizeByte];
        }
    }
}

