/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.kie.workbench.common.services.refactoring.KPropertyImpl;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.IndexBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.util.KObjectUtil;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.annotations.VisibleAsset;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class LibraryIndexer
extends AbstractFileIndexer {
    private static final Logger logger = LoggerFactory.getLogger(LibraryIndexer.class);
    private static final String LIBRARY_CLASSIFIER = "library";
    private Set<ResourceTypeDefinition> visibleResourceTypes;

    public LibraryIndexer() {
        this.visibleResourceTypes = new HashSet<ResourceTypeDefinition>();
    }

    @Inject
    public LibraryIndexer(@VisibleAsset Instance<ResourceTypeDefinition> visibleResourceTypeDefinitions) {
        this.visibleResourceTypes = StreamSupport.stream(visibleResourceTypeDefinitions.spliterator(), false).collect(Collectors.toSet());
    }

    void setIOService(IOService ioService) {
        this.ioService = ioService;
    }

    void setModuleService(KieModuleService moduleService) {
        this.moduleService = moduleService;
    }

    public boolean supportsPath(Path path) {
        return !this.isFolder(path) && !this.isHidden(path) && this.isSupportedByAnyResourceType(path);
    }

    private boolean isSupportedByAnyResourceType(Path path) {
        org.uberfire.backend.vfs.Path convertedPath = this.convertPath(path);
        return this.getVisibleResourceTypes().stream().anyMatch(resourceTypeDefinition -> resourceTypeDefinition.accept(convertedPath));
    }

    public String getIndexerId() {
        return "org.kie.workbench.common.LibraryAssetIndexer";
    }

    protected IndexBuilder fillIndexBuilder(Path path) throws Exception {
        String fileName = Paths.convert((Path)path).getFileName();
        String repoRoot = this.getRootBackendPath(path);
        IndexBuilder builder = () -> {
            HashSet<KPropertyImpl> indexElements = new HashSet<KPropertyImpl>();
            indexElements.add(new KPropertyImpl("libraryFileName", (Object)fileName));
            indexElements.add(new KPropertyImpl("filenamesorted", (Object)fileName.toLowerCase(), false, true));
            indexElements.add(new KPropertyImpl("libraryRepositoryRoot", (Object)repoRoot));
            return indexElements;
        };
        return builder;
    }

    private String getRootBackendPath(Path path) {
        Path root = path;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return Paths.convert((Path)root).toURI();
    }

    public KObject toKObject(Path path) {
        KObject index = null;
        try {
            IndexBuilder builder = this.fillIndexBuilder(path);
            Set indexElements = null;
            indexElements = builder != null ? builder.build() : Collections.emptySet();
            index = KObjectUtil.toKObject((Path)path, (String)LIBRARY_CLASSIFIER, (Set)indexElements);
        }
        catch (Exception e) {
            logger.error("Unable to index '" + path.toUri().toString() + "'.", (Object)e.getMessage(), (Object)e);
        }
        return index;
    }

    public KObjectKey toKObjectKey(Path path) {
        return KObjectUtil.toKObjectKey((Path)path, (String)LIBRARY_CLASSIFIER);
    }

    protected org.uberfire.backend.vfs.Path convertPath(Path path) {
        return Paths.convert((Path)path);
    }

    protected KieModule getModule(Path path) {
        return (KieModule)this.moduleService.resolveModule(Paths.convert((Path)path), false);
    }

    protected Package getPackage(Path path) {
        return this.moduleService.resolvePackage(Paths.convert((Path)path));
    }

    protected boolean isFolder(Path path) {
        return Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0]);
    }

    protected boolean isHidden(Path path) {
        return path.getFileName().startsWith(".");
    }

    protected Set<ResourceTypeDefinition> getVisibleResourceTypes() {
        return this.visibleResourceTypes;
    }
}

