/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.screens.workbench.backend.impl;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.apache.lucene.analysis.Analyzer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.ImpactAnalysisAnalyzerWrapperFactory;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.LowerCaseOnlyAnalyzer;
import org.uberfire.ext.metadata.MetadataConfig;
import org.uberfire.ext.metadata.backend.lucene.analyzer.FilenameAnalyzer;
import org.uberfire.ext.metadata.backend.lucene.index.CustomAnalyzerWrapperFactory;
import org.uberfire.ext.metadata.io.MetadataConfigBuilder;

@ApplicationScoped
public class DefaultLuceneConfigProducer {
    private MetadataConfig config;

    @PostConstruct
    public void setup() {
        Map<String, Analyzer> analyzers = this.getAnalyzers();
        this.config = new MetadataConfigBuilder().withInMemoryMetaModelStore().usingAnalyzers(analyzers).usingAnalyzerWrapperFactory((CustomAnalyzerWrapperFactory)ImpactAnalysisAnalyzerWrapperFactory.getInstance()).useDirectoryBasedIndex().useNIODirectory().build();
    }

    @Produces
    @Named(value="luceneConfig")
    public MetadataConfig configProducer() {
        return this.config;
    }

    Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("libraryFileName", new FilenameAnalyzer());
                this.put("libraryRepositoryRoot", new FilenameAnalyzer());
                this.put("projectRoot", new FilenameAnalyzer());
                this.put("packageName", new LowerCaseOnlyAnalyzer());
                this.put("filename", new FilenameAnalyzer());
            }
        };
    }
}

