/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.nearby;

import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;

public class NearEntityNearbyValueSelector
extends AbstractValueSelector {
    protected final ValueSelector childValueSelector;
    protected final EntitySelector originEntitySelector;
    protected final NearbyDistanceMeter nearbyDistanceMeter;
    protected final NearbyRandom nearbyRandom;
    protected final boolean randomSelection;
    protected final boolean discardNearbyIndexZero;
    protected NearbyDistanceMatrix nearbyDistanceMatrix = null;

    public NearEntityNearbyValueSelector(ValueSelector childValueSelector, EntitySelector originEntitySelector, NearbyDistanceMeter nearbyDistanceMeter, NearbyRandom nearbyRandom, boolean randomSelection) {
        this.childValueSelector = childValueSelector;
        this.originEntitySelector = originEntitySelector;
        this.nearbyDistanceMeter = nearbyDistanceMeter;
        this.nearbyRandom = nearbyRandom;
        this.randomSelection = randomSelection;
        if (randomSelection && nearbyRandom == null) {
            throw new IllegalArgumentException("The valueSelector (" + this + ") with randomSelection (" + randomSelection + ") has no nearbyRandom (" + nearbyRandom + ").");
        }
        this.discardNearbyIndexZero = childValueSelector.getVariableDescriptor().getVariablePropertyType().isAssignableFrom(originEntitySelector.getEntityDescriptor().getEntityClass());
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
        this.phaseLifecycleSupport.addEventListener(originEntitySelector);
    }

    @Override
    public GenuineVariableDescriptor getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public void phaseStarted(AbstractPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        long originSize = this.originEntitySelector.getSize();
        if (originSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The originEntitySelector (" + this.originEntitySelector + ") has an entitySize (" + originSize + ") which is higher than Integer.MAX_VALUE.");
        }
        this.nearbyDistanceMatrix = new NearbyDistanceMatrix(this.nearbyDistanceMeter, (int)originSize);
        Iterator<Object> originIt = this.originEntitySelector.endingIterator();
        while (originIt.hasNext()) {
            Object origin = originIt.next();
            long childSize = this.childValueSelector.getSize(origin);
            if (childSize > Integer.MAX_VALUE) {
                throw new IllegalStateException("The childEntitySelector (" + this.childValueSelector + ") has an entitySize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
            }
            int destinationSize = (int)childSize;
            if (this.randomSelection) {
                int overallSizeMaximum = this.nearbyRandom.getOverallSizeMaximum();
                if (this.discardNearbyIndexZero && overallSizeMaximum < Integer.MAX_VALUE) {
                    ++overallSizeMaximum;
                }
                if (destinationSize > overallSizeMaximum) {
                    destinationSize = overallSizeMaximum;
                }
            }
            this.nearbyDistanceMatrix.addAllDestinations(origin, this.childValueSelector.endingIterator(origin), destinationSize);
        }
    }

    @Override
    public void phaseEnded(AbstractPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.nearbyDistanceMatrix = null;
    }

    @Override
    public boolean isCountable() {
        return this.childValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || !this.isCountable();
    }

    @Override
    public long getSize(Object entity) {
        return this.childValueSelector.getSize(entity) - (long)(this.discardNearbyIndexZero ? 1 : 0);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        if (!this.randomSelection) {
            return new OriginalEntityNearbyValueIterator(this.originEntitySelector.iterator(), this.childValueSelector.getSize(entity));
        }
        return new RandomEntityNearbyValueIterator(this.originEntitySelector.iterator(), this.childValueSelector.getSize(entity));
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return this.childValueSelector.endingIterator(entity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.originEntitySelector + ", " + this.childValueSelector + ")";
    }

    private class RandomEntityNearbyValueIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> originEntityIterator;
        private final int nearbySize;

        public RandomEntityNearbyValueIterator(Iterator<Object> originEntityIterator, long childSize) {
            this.originEntityIterator = originEntityIterator;
            if (childSize > Integer.MAX_VALUE) {
                throw new IllegalStateException("The valueSelector (" + this + ") has an entitySize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
            }
            this.nearbySize = (int)childSize - (NearEntityNearbyValueSelector.this.discardNearbyIndexZero ? 1 : 0);
        }

        @Override
        public boolean hasNext() {
            return this.originEntityIterator.hasNext() && this.nearbySize > 0;
        }

        @Override
        public Object next() {
            Object origin = this.originEntityIterator.next();
            int nearbyIndex = NearEntityNearbyValueSelector.this.nearbyRandom.nextInt(NearEntityNearbyValueSelector.this.workingRandom, this.nearbySize);
            if (NearEntityNearbyValueSelector.this.discardNearbyIndexZero) {
                ++nearbyIndex;
            }
            return NearEntityNearbyValueSelector.this.nearbyDistanceMatrix.getDestination(origin, nearbyIndex);
        }
    }

    private class OriginalEntityNearbyValueIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> originEntityIterator;
        private final long childSize;
        private boolean originSelected = false;
        private boolean originIsNotEmpty;
        private Object origin;
        private int nextNearbyIndex;

        public OriginalEntityNearbyValueIterator(Iterator<Object> originEntityIterator, long childSize) {
            this.originEntityIterator = originEntityIterator;
            this.childSize = childSize;
            this.nextNearbyIndex = NearEntityNearbyValueSelector.this.discardNearbyIndexZero ? 1 : 0;
        }

        private void selectOrigin() {
            if (this.originSelected) {
                return;
            }
            this.originIsNotEmpty = this.originEntityIterator.hasNext();
            this.origin = this.originEntityIterator.next();
            this.originSelected = true;
        }

        @Override
        public boolean hasNext() {
            this.selectOrigin();
            return this.originIsNotEmpty && (long)this.nextNearbyIndex < this.childSize;
        }

        @Override
        public Object next() {
            this.selectOrigin();
            Object next = NearEntityNearbyValueSelector.this.nearbyDistanceMatrix.getDestination(this.origin, this.nextNearbyIndex);
            ++this.nextNearbyIndex;
            return next;
        }
    }
}

