/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.service;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceRuntimeManager;
import org.kie.workbench.common.screens.datasource.management.backend.core.DeploymentOptions;
import org.kie.workbench.common.screens.datasource.management.backend.core.DriverDefDeployer;
import org.kie.workbench.common.screens.datasource.management.backend.service.AbstractDefDeployer;
import org.kie.workbench.common.screens.datasource.management.backend.service.DefRegistry;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;
import org.kie.workbench.common.screens.datasource.management.model.DriverDefInfo;
import org.kie.workbench.common.screens.datasource.management.service.DataSourceDefQueryService;
import org.kie.workbench.common.screens.datasource.management.util.DriverDefSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;

@ApplicationScoped
public class DriverDefDeployerImpl
extends AbstractDefDeployer<DriverDefInfo>
implements DriverDefDeployer {
    private static final Logger logger = LoggerFactory.getLogger(DriverDefDeployerImpl.class);

    public DriverDefDeployerImpl() {
    }

    @Inject
    public DriverDefDeployerImpl(@Named(value="ioStrategy") IOService ioService, DataSourceDefQueryService queryService, DataSourceRuntimeManager runtimeManager, DefRegistry defRegistry) {
        super(ioService, queryService, runtimeManager, defRegistry);
    }

    @Override
    protected Collection<DriverDefInfo> findGlobalDefs() {
        return this.queryService.findGlobalDrivers();
    }

    @Override
    protected Collection<DriverDefInfo> findProjectDefs(Path path) {
        return this.queryService.findModuleDrivers(path);
    }

    @Override
    protected void deployDef(DriverDefInfo defInfo) {
        try {
            logger.debug("Deploying driver def: " + defInfo);
            String source = this.ioService.readAllString(Paths.convert((Path)defInfo.getPath()));
            DriverDef driverDef = DriverDefSerializer.deserialize(source);
            this.runtimeManager.deployDriver(driverDef, DeploymentOptions.createOrResync());
            this.defRegistry.setEntry(defInfo.getPath(), driverDef);
            logger.debug("Driver was successfully deployed");
        }
        catch (Exception e) {
            logger.error("Driver deployment failed, defInfo: " + defInfo, (Throwable)e);
        }
    }
}

