/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;

public class FileHashingUtils {
    private static final String FILE_HASH_EMPTY_TAG = "$HASH()";
    private static final String FILE_HASH_EMPTY_EXPRESSION = "\\$HASH\\(\\)";
    private static final String MD5_VALUE_EXPRESSION = "\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w";
    private static final String FILE_HASH_EXPRESSION = "\\$HASH\\(\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\)";
    private static final Pattern fileHashEmptyPattern = Pattern.compile("\\$HASH\\(\\)");
    private static final Pattern md5ValuePattern = Pattern.compile("\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w");
    private static final Pattern fileHashPattern = Pattern.compile("\\$HASH\\(\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\w\\)");

    public static String setFileHashValue(String content) {
        return FileHashingUtils.setFileHashValue(content, FileHashingUtils.md5Hex(content));
    }

    public static String extractFileHashValue(String content) {
        Matcher md5ValueMatcher;
        if (content == null || "".equals(content)) {
            return null;
        }
        Matcher fileHashMatcher = fileHashPattern.matcher(content);
        String fileHashValue = null;
        String md5Value = null;
        if (fileHashMatcher.find() && (md5ValueMatcher = md5ValuePattern.matcher(fileHashValue = fileHashMatcher.group())).find()) {
            md5Value = md5ValueMatcher.group();
        }
        return md5Value;
    }

    public static boolean verifiesHash(String content) {
        return FileHashingUtils.verifiesHash(content, FileHashingUtils.extractFileHashValue(content));
    }

    public static boolean verifiesHash(String content, String expectedHashValue) {
        if (content == null || "".equals(content) || expectedHashValue == null || "".equals(expectedHashValue)) {
            return false;
        }
        content = content.replace(expectedHashValue, "");
        String hashValue = FileHashingUtils.md5Hex(content);
        return expectedHashValue.equals(hashValue);
    }

    private static String setFileHashValue(String content, String hashValue) {
        if (content == null || hashValue == null) {
            return content;
        }
        return content.replaceFirst(FILE_HASH_EMPTY_EXPRESSION, "\\$HASH(" + hashValue + ")");
    }

    public static String md5Hex(String content) {
        if (content == null) {
            return null;
        }
        return DigestUtils.md5Hex((String)content);
    }

    public static String getFileHashEmptyTag() {
        return FILE_HASH_EMPTY_TAG;
    }
}

