/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.util;

import java.util.Iterator;
import java.util.List;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.Importer;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodHolderSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;
import org.jboss.forge.roaster.model.source.PropertySource;

public class DesignPatterns {
    private DesignPatterns() {
    }

    public static JavaClassSource createBuilder(JavaClassSource javaClass) {
        String builderClassName = javaClass.getName() + "Builder";
        JavaClassSource builderClass = (JavaClassSource)((JavaClassSource)Roaster.create(JavaClassSource.class).setName(builderClassName)).setPackage(javaClass.getPackage());
        for (Import import_ : javaClass.getImports()) {
            builderClass.addImport(import_);
        }
        ((FieldSource)((FieldSource)((FieldSource)builderClass.addField().setPrivate()).setFinal(true)).setType(javaClass).setName("obj")).setLiteralInitializer("new " + javaClass.getName() + "();");
        ((MethodSource)((MethodSource)((MethodSource)builderClass.addMethod().setPublic()).setStatic(true)).setName("create")).setReturnType(builderClass).setBody("return new " + builderClassName + "();");
        ((MethodSource)builderClass.addMethod().setConstructor(true).setPrivate()).setBody("");
        ((MethodSource)((MethodSource)builderClass.addMethod().setPublic()).setReturnType(javaClass).setName("build")).setBody("return obj;");
        for (PropertySource propertySource : javaClass.getProperties()) {
            String propertyName = propertySource.getName();
            String upperCasedName = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            MethodSource method = (MethodSource)((MethodSource)builderClass.addMethod().setPublic()).setReturnType(builderClass).setName("with" + upperCasedName);
            method.addParameter(propertySource.getType().getQualifiedName(), "param");
            method.setBody("obj.set" + upperCasedName + "(param);return this;");
        }
        return builderClass;
    }

    public static JavaClassSource createDecorator(JavaType<?> javaSource) {
        String decoratorClassName = javaSource.getName() + "Decorator";
        JavaClassSource decoratorClass = (JavaClassSource)((JavaClassSource)Roaster.create(JavaClassSource.class).setName(decoratorClassName)).setPackage(javaSource.getPackage());
        if (javaSource instanceof Importer) {
            List<Import> imports = ((Importer)((Object)javaSource)).getImports();
            for (Import i : imports) {
                decoratorClass.addImport(i);
            }
        }
        MethodSource constructor = ((MethodSource)decoratorClass.addMethod().setPublic()).setConstructor(true);
        constructor.addParameter(javaSource, "delegate");
        constructor.setBody("this.delegate = delegate;");
        ((FieldSource)((FieldSource)decoratorClass.addField().setPrivate()).setFinal(true)).setType(javaSource).setName("delegate");
        if (javaSource instanceof MethodHolderSource) {
            List methods = ((MethodHolderSource)((Object)javaSource)).getMethods();
            for (MethodSource method : methods) {
                if (method.isPrivate()) continue;
                MethodSource decoratorMethod = (MethodSource)((MethodSource)decoratorClass.addMethod().setPublic()).setName(method.getName());
                StringBuilder sb = new StringBuilder();
                if (method.isReturnTypeVoid()) {
                    decoratorMethod.setReturnTypeVoid();
                    sb.append("delegate.");
                } else {
                    sb.append("return delegate.");
                    decoratorMethod.setReturnType(method.getReturnType().getQualifiedName());
                }
                sb.append(method.getName()).append("(");
                List parameters = method.getParameters();
                Iterator iterator = parameters.iterator();
                while (iterator.hasNext()) {
                    ParameterSource param = iterator.next();
                    sb.append(param.getName());
                    if (iterator.hasNext()) {
                        sb.append(",");
                    }
                    decoratorMethod.addParameter(param.getType().getQualifiedName(), param.getName());
                }
                sb.append(");");
                for (String o : method.getThrownExceptions()) {
                    decoratorMethod.addThrows(o);
                }
                decoratorMethod.setBody(sb.toString());
            }
        }
        return decoratorClass;
    }
}

