/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.dynamic.service.shared;

import java.util.HashMap;
import java.util.Map;
import org.kie.workbench.common.forms.dynamic.model.config.SelectorData;
import org.kie.workbench.common.forms.dynamic.model.config.SelectorDataProvider;
import org.kie.workbench.common.forms.dynamic.model.config.SystemSelectorDataProvider;
import org.kie.workbench.common.forms.dynamic.service.shared.FormRenderingContext;
import org.kie.workbench.common.forms.dynamic.service.shared.SelectorDataProviderManager;

public abstract class AbstractSelectorDataProviderManager
implements SelectorDataProviderManager {
    protected Map<String, SelectorDataProvider> providers = new HashMap<String, SelectorDataProvider>();

    protected void registerProvider(SelectorDataProvider provider) {
        this.providers.put(this.getPreffix() + ":" + provider.getClass().getName(), provider);
    }

    @Override
    public Map<String, String> availableProviders() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : this.providers.keySet()) {
            SelectorDataProvider provider = this.providers.get(key);
            if (provider instanceof SystemSelectorDataProvider) continue;
            result.put(key, provider.getProviderName());
        }
        return result;
    }

    @Override
    public SelectorData getDataFromProvider(FormRenderingContext context, String provider) {
        SelectorDataProvider dataProvider = this.providers.get(provider);
        if (dataProvider == null) {
            return null;
        }
        return dataProvider.getSelectorData(context);
    }

    public abstract String getPreffix();
}

