/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.services.rest;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.guvnor.ala.config.ProviderConfig;
import org.guvnor.ala.config.RuntimeConfig;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTrace;
import org.guvnor.ala.registry.PipelineExecutorRegistry;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeEndpoint;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.guvnor.ala.services.api.PipelineStageItem;
import org.guvnor.ala.services.api.RuntimeProvisioningService;
import org.guvnor.ala.services.api.RuntimeQuery;
import org.guvnor.ala.services.api.RuntimeQueryResultItem;
import org.guvnor.ala.services.api.itemlist.PipelineStageItemList;
import org.guvnor.ala.services.api.itemlist.ProviderList;
import org.guvnor.ala.services.api.itemlist.ProviderTypeList;
import org.guvnor.ala.services.api.itemlist.RuntimeList;
import org.guvnor.ala.services.api.itemlist.RuntimeQueryResultItemList;
import org.guvnor.ala.services.exceptions.BusinessException;
import org.guvnor.ala.services.rest.factories.ProviderFactory;
import org.guvnor.ala.services.rest.factories.RuntimeFactory;
import org.guvnor.ala.services.rest.factories.RuntimeManagerFactory;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RestRuntimeProvisioningServiceImpl
implements RuntimeProvisioningService {
    private static final Logger LOG = LoggerFactory.getLogger(RestRuntimeProvisioningServiceImpl.class);
    private BeanManager beanManager;
    private ProviderFactory providerFactory;
    private RuntimeRegistry runtimeRegistry;
    private RuntimeFactory runtimeFactory;
    private RuntimeManagerFactory runtimeManagerFactory;
    private PipelineExecutorRegistry pipelineExecutorRegistry;

    public RestRuntimeProvisioningServiceImpl() {
    }

    @Inject
    public RestRuntimeProvisioningServiceImpl(BeanManager beanManager, ProviderFactory providerFactory, RuntimeRegistry runtimeRegistry, RuntimeFactory runtimeFactory, RuntimeManagerFactory runtimeManagerFactory, PipelineExecutorRegistry pipelineExecutorRegistry) {
        this.beanManager = beanManager;
        this.providerFactory = providerFactory;
        this.runtimeRegistry = runtimeRegistry;
        this.runtimeFactory = runtimeFactory;
        this.runtimeManagerFactory = runtimeManagerFactory;
        this.pipelineExecutorRegistry = pipelineExecutorRegistry;
    }

    @PostConstruct
    public void cacheBeans() {
        LOG.info("> Initializing ProviderTypes. ");
        Set beans = this.beanManager.getBeans(ProviderType.class, new Annotation[]{new AnnotationLiteral<Any>(){}});
        for (Bean b : beans) {
            try {
                ProviderType pt = (ProviderType)b.getBeanClass().newInstance();
                LOG.info("> Registering ProviderType: " + pt.getProviderTypeName());
                this.runtimeRegistry.registerProviderType(pt);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                LOG.error("Something went wrong with registering Provider Types!", (Throwable)ex);
            }
        }
    }

    public ProviderTypeList getProviderTypes(Integer page, Integer pageSize, String sort, boolean sortOrder) throws BusinessException {
        return new ProviderTypeList(this.runtimeRegistry.getProviderTypes(page, pageSize, sort, sortOrder));
    }

    public ProviderList getProviders(Integer page, Integer pageSize, String sort, boolean sortOrder) throws BusinessException {
        return new ProviderList(this.runtimeRegistry.getProviders(page, pageSize, sort, sortOrder));
    }

    public RuntimeList getRuntimes(Integer page, Integer pageSize, String sort, boolean sortOrder) throws BusinessException {
        return new RuntimeList(this.runtimeRegistry.getRuntimes(page, pageSize, sort, sortOrder));
    }

    public void registerProvider(ProviderConfig conf) throws BusinessException {
        Optional<Provider> newProvider = this.providerFactory.newProvider(conf);
        if (newProvider.isPresent()) {
            this.runtimeRegistry.registerProvider(newProvider.get());
        }
    }

    public void deregisterProvider(String name) throws BusinessException {
        this.runtimeRegistry.deregisterProvider(name);
    }

    public String newRuntime(RuntimeConfig conf) throws BusinessException {
        Optional<Runtime> newRuntime = this.runtimeFactory.newRuntime(conf);
        if (newRuntime.isPresent()) {
            return newRuntime.get().getId();
        }
        return null;
    }

    public void destroyRuntime(String runtimeId, boolean forced) throws BusinessException {
        Runtime runtimeById = this.runtimeRegistry.getRuntimeById(runtimeId);
        if (runtimeById == null) {
            throw new BusinessException("No runtime was found for runtimeId: " + runtimeId);
        }
        PipelineExecutorTrace pipelineTrace = this.pipelineExecutorRegistry.getExecutorTrace((RuntimeId)runtimeById);
        try {
            this.runtimeFactory.destroyRuntime((RuntimeId)runtimeById);
        }
        catch (Exception e) {
            if (forced) {
                LOG.warn("Runtime destroy raised the following error for runtime: " + runtimeId + " but forced destroy will still remove the runtime from registry.", (Throwable)e);
                this.runtimeRegistry.deregisterRuntime((RuntimeId)runtimeById);
            }
            throw e;
        }
        if (pipelineTrace != null) {
            this.pipelineExecutorRegistry.deregister(pipelineTrace.getTaskId());
        }
    }

    public void startRuntime(String runtimeId) throws BusinessException {
        Runtime runtimeById = this.runtimeRegistry.getRuntimeById(runtimeId);
        if (runtimeById == null) {
            throw new BusinessException("No runtime was found for runtimeId: " + runtimeId);
        }
        this.runtimeManagerFactory.startRuntime((RuntimeId)runtimeById);
    }

    public void stopRuntime(String runtimeId) throws BusinessException {
        Runtime runtimeById = this.runtimeRegistry.getRuntimeById(runtimeId);
        if (runtimeById == null) {
            throw new BusinessException("No runtime was found for runtimeId: " + runtimeId);
        }
        this.runtimeManagerFactory.stopRuntime((RuntimeId)runtimeById);
    }

    public void restartRuntime(String runtimeId) throws BusinessException {
        Runtime runtimeById = this.runtimeRegistry.getRuntimeById(runtimeId);
        if (runtimeById == null) {
            throw new BusinessException("No runtime was found for runtimeId: " + runtimeId);
        }
        this.runtimeManagerFactory.restartRuntime((RuntimeId)runtimeById);
    }

    public RuntimeQueryResultItemList executeQuery(RuntimeQuery query) throws BusinessException {
        PortablePreconditions.checkNotNull((String)"query", (Object)query);
        PipelineExecutorTraceFilter traceFilter = PipelineExecutorTraceFilter.newInstance().withPipelineExecutionId(query.getPipelineExecutionId()).withRuntimeId(query.getRuntimeId()).withRuntimeName(query.getRuntimeName()).withProviderId(query.getProviderId()).withPipelineId(query.getPipelineId());
        Collection pipelineTraces = this.pipelineExecutorRegistry.getExecutorTraces().stream().filter(traceFilter).collect(Collectors.toList());
        if (query.getPipelineId() != null) {
            return new RuntimeQueryResultItemList(this.buildResultItemList(pipelineTraces, this.runtimeRegistry));
        }
        List<RuntimeQueryResultItem> items = this.buildResultItemList(pipelineTraces, this.runtimeRegistry);
        List runtimes = this.runtimeRegistry.getRuntimes(Integer.valueOf(0), Integer.valueOf(1000), "id", true);
        RuntimeFilter runtimeFilter = RuntimeFilter.newInstance().withProviderId(query.getProviderId()).withRuntimeId(query.getRuntimeId()).withRuntimeName(query.getRuntimeName());
        runtimes.forEach(runtime -> {
            if (runtimeFilter.test((Runtime)runtime) && items.stream().filter(item -> runtime.getId().equals(item.getRuntimeId()) && runtime.getProviderId().getId().equals(item.getProviderId())).count() == 0L) {
                items.add(RuntimeQueryResultItemBuilder.newInstance(this.runtimeRegistry).with((Runtime)runtime).build());
            }
        });
        return new RuntimeQueryResultItemList(items);
    }

    private List<RuntimeQueryResultItem> buildResultItemList(Collection<PipelineExecutorTrace> pipelineExecutorTraces, RuntimeRegistry runtimeRegistry) {
        return pipelineExecutorTraces.stream().map(trace -> RuntimeQueryResultItemBuilder.newInstance(runtimeRegistry).with((PipelineExecutorTrace)trace).build()).collect(Collectors.toList());
    }

    static class RuntimeFilter
    implements Predicate<Runtime> {
        private String providerId;
        private String runtimeId;
        private String runtimeName;

        private RuntimeFilter() {
        }

        public static RuntimeFilter newInstance() {
            return new RuntimeFilter();
        }

        public RuntimeFilter withProviderId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public RuntimeFilter withRuntimeId(String runtimeId) {
            this.runtimeId = runtimeId;
            return this;
        }

        public RuntimeFilter withRuntimeName(String runtimeName) {
            this.runtimeName = runtimeName;
            return this;
        }

        @Override
        public boolean test(Runtime runtime) {
            if (this.runtimeId != null) {
                return this.runtimeId.equals(runtime.getId());
            }
            if (this.runtimeName != null) {
                return this.runtimeName.equals(runtime.getName());
            }
            return this.providerId == null || this.providerId.equals(runtime.getProviderId().getId());
        }
    }

    static class PipelineExecutorTraceFilter
    implements Predicate<PipelineExecutorTrace> {
        private String providerId;
        private String pipelineId;
        private String pipelineExecutionId;
        private String runtimeId;
        private String runtimeName;

        private PipelineExecutorTraceFilter() {
        }

        public static PipelineExecutorTraceFilter newInstance() {
            return new PipelineExecutorTraceFilter();
        }

        public PipelineExecutorTraceFilter withProviderId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public PipelineExecutorTraceFilter withPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public PipelineExecutorTraceFilter withPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public PipelineExecutorTraceFilter withRuntimeId(String runtimeId) {
            this.runtimeId = runtimeId;
            return this;
        }

        public PipelineExecutorTraceFilter withRuntimeName(String runtimeName) {
            this.runtimeName = runtimeName;
            return this;
        }

        @Override
        public boolean test(PipelineExecutorTrace pipelineExecutorTrace) {
            if (this.pipelineExecutionId != null) {
                return this.pipelineExecutionId.equals(pipelineExecutorTrace.getTaskId());
            }
            if (this.runtimeId != null) {
                return pipelineExecutorTrace.getTask().getOutput() instanceof RuntimeId && this.runtimeId.equals(((RuntimeId)pipelineExecutorTrace.getTask().getOutput()).getId());
            }
            if (this.runtimeName != null) {
                return pipelineExecutorTrace.getTask().getOutput() instanceof RuntimeId && this.runtimeName.equals(((RuntimeId)pipelineExecutorTrace.getTask().getOutput()).getName());
            }
            if (this.providerId != null) {
                if (pipelineExecutorTrace.getTask().getTaskDef().getProviderId() == null) {
                    return false;
                }
                if (!this.providerId.equals(pipelineExecutorTrace.getTask().getTaskDef().getProviderId().getId())) {
                    return false;
                }
            }
            return this.pipelineId == null || this.pipelineId.equals(pipelineExecutorTrace.getPipelineId());
        }
    }

    static class RuntimeEndpointBuilder {
        private Runtime runtime;

        private RuntimeEndpointBuilder() {
        }

        public static RuntimeEndpointBuilder newInstance() {
            return new RuntimeEndpointBuilder();
        }

        private RuntimeEndpointBuilder with(Runtime runtime) {
            this.runtime = runtime;
            return this;
        }

        public String build() {
            RuntimeEndpoint endpoint = this.runtime.getEndpoint();
            if (endpoint != null) {
                String context;
                StringBuilder ep = new StringBuilder();
                String protocol = endpoint.getProtocol();
                if (protocol == null) {
                    protocol = "http";
                }
                ep.append(protocol);
                ep.append("://");
                String host = endpoint.getHost();
                if (host == null) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn(String.format("Host undefined in RuntimeEndpoint: %s. defaulting to \"localhost\".", endpoint));
                    }
                    host = "localhost";
                }
                ep.append(host);
                Integer port = endpoint.getPort();
                if (port != null) {
                    ep.append(':');
                    ep.append(port);
                }
                if ((context = endpoint.getContext()) != null) {
                    if (!context.startsWith("/")) {
                        ep.append('/');
                    }
                    ep.append(context);
                }
                return ep.toString();
            }
            return null;
        }
    }

    static class RuntimeQueryResultItemBuilder {
        private RuntimeRegistry runtimeRegistry;
        private PipelineExecutorTrace pipelineExecutorTrace;
        private Runtime runtime;

        private RuntimeQueryResultItemBuilder(RuntimeRegistry runtimeRegistry) {
            this.runtimeRegistry = runtimeRegistry;
        }

        public static RuntimeQueryResultItemBuilder newInstance(RuntimeRegistry runtimeRegistry) {
            return new RuntimeQueryResultItemBuilder(runtimeRegistry);
        }

        public RuntimeQueryResultItemBuilder with(PipelineExecutorTrace pipelineExecutorTrace) {
            this.pipelineExecutorTrace = pipelineExecutorTrace;
            return this;
        }

        public RuntimeQueryResultItemBuilder with(Runtime runtime) {
            this.runtime = runtime;
            return this;
        }

        public RuntimeQueryResultItem build() {
            RuntimeQueryResultItem item = new RuntimeQueryResultItem();
            if (this.pipelineExecutorTrace != null) {
                if (this.pipelineExecutorTrace.getTask().getTaskDef().getProviderId() != null) {
                    item.setProviderId(this.pipelineExecutorTrace.getTask().getTaskDef().getProviderId().getId());
                    item.setProviderTypeName(this.pipelineExecutorTrace.getTask().getTaskDef().getProviderId().getProviderType().getProviderTypeName());
                    item.setProviderVersion(this.pipelineExecutorTrace.getTask().getTaskDef().getProviderId().getProviderType().getVersion());
                }
                item.setPipelineId(this.pipelineExecutorTrace.getPipelineId());
                item.setPipelineExecutionId(this.pipelineExecutorTrace.getTaskId());
                item.setPipelineStatus(this.pipelineExecutorTrace.getTask().getPipelineStatus().name());
                if (this.pipelineExecutorTrace.getTask().getPipelineError() != null) {
                    item.setPipelineError(this.pipelineExecutorTrace.getTask().getPipelineError().getError());
                    item.setPipelineErrorDetail(this.pipelineExecutorTrace.getTask().getPipelineError().getErrorDetail());
                }
                List stageItems = this.pipelineExecutorTrace.getTask().getTaskDef().getStages().stream().map(stage -> {
                    String stageError = null;
                    String stageErrorDetail = null;
                    if (this.pipelineExecutorTrace.getTask().getStageError(stage) != null) {
                        stageError = this.pipelineExecutorTrace.getTask().getStageError(stage).getError();
                        stageErrorDetail = this.pipelineExecutorTrace.getTask().getStageError(stage).getErrorDetail();
                    }
                    String stageStatus = null;
                    if (this.pipelineExecutorTrace.getTask().getStageStatus(stage) != null) {
                        stageStatus = this.pipelineExecutorTrace.getTask().getStageStatus(stage).name();
                    }
                    return new PipelineStageItem(stage, stageStatus, stageError, stageErrorDetail);
                }).collect(Collectors.toList());
                item.setPipelineStageItems(new PipelineStageItemList(stageItems));
                if (this.pipelineExecutorTrace.getTask().getOutput() instanceof Runtime) {
                    Runtime runtime = this.runtimeRegistry.getRuntimeById(((Runtime)this.pipelineExecutorTrace.getTask().getOutput()).getId());
                    if (runtime != null) {
                        item.setRuntimeId(runtime.getId());
                        item.setRuntimeName(runtime.getName());
                        item.setRuntimeStatus(runtime.getState().getState());
                        item.setStartedAt(runtime.getState().getStartedAt());
                        item.setRuntimeEndpoint(RuntimeEndpointBuilder.newInstance().with(runtime).build());
                    }
                } else {
                    item.setRuntimeName((String)this.pipelineExecutorTrace.getTask().getTaskDef().getInput().get((Object)"runtime-name"));
                }
            } else if (this.runtime != null) {
                item.setProviderId(this.runtime.getProviderId().getId());
                item.setRuntimeId(this.runtime.getId());
                item.setRuntimeName(this.runtime.getName());
                item.setRuntimeStatus(this.runtime.getState().getState());
                item.setStartedAt(this.runtime.getState().getStartedAt());
                item.setRuntimeEndpoint(RuntimeEndpointBuilder.newInstance().with(this.runtime).build());
            }
            return item;
        }
    }
}

