/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.service.backend.keystore.impl;

import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.ssh.service.backend.keystore.SSHKeyStore;
import org.uberfire.ssh.service.backend.keystore.SSHKeyStoreService;
import org.uberfire.ssh.service.backend.keystore.impl.storage.DefaultSSHKeyStore;

@Startup
@ApplicationScoped
public class SSHKeyStoreServiceImpl
implements SSHKeyStoreService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSHKeyStoreServiceImpl.class);
    private SSHKeyStore keyStore;

    protected SSHKeyStoreServiceImpl() {
    }

    @Inject
    public SSHKeyStoreServiceImpl(Instance<SSHKeyStore> keyStores) {
        if (!keyStores.isUnsatisfied()) {
            try {
                Class<? extends SSHKeyStore> keystoreClass = this.getSSHKeyStoreType();
                LOGGER.info("Looking up SSHKeyStore {}", keystoreClass);
                this.keyStore = (SSHKeyStore)keyStores.select(keystoreClass, new Annotation[0]).get();
            }
            catch (Exception ex) {
                LOGGER.error("Impossible to lookup any SSHKeyStore named instance: ", (Throwable)ex);
                this.loadDefaultKeyStore();
            }
        } else {
            this.loadDefaultKeyStore();
        }
    }

    private Class<? extends SSHKeyStore> getSSHKeyStoreType() {
        String sshKeyStoreType;
        Optional<String> optional = Optional.ofNullable(System.getProperty("appformer.ssh.keystore"));
        if (optional.isPresent() && !(sshKeyStoreType = optional.get()).isEmpty()) {
            try {
                return Class.forName(sshKeyStoreType);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Cannot lookup configured SSHKeystore ('{}'), looking up default keystore", (Object)sshKeyStoreType);
            }
        }
        return DefaultSSHKeyStore.class;
    }

    private void loadDefaultKeyStore() {
        LOGGER.debug("Loading a default SSHKeyStore.");
        DefaultSSHKeyStore defaultSSHKeyStore = new DefaultSSHKeyStore();
        defaultSSHKeyStore.init();
        this.keyStore = defaultSSHKeyStore;
    }

    public SSHKeyStore keyStore() {
        return this.keyStore;
    }
}

