/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.archetype.mgmt.backend.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenExecutionResult;
import org.appformer.maven.integration.embedder.MavenEmbedderException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.guvnor.common.services.project.backend.server.utils.PathUtil;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.structure.organizationalunit.NewOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.archetype.mgmt.backend.config.ArchetypeConfigStorage;
import org.kie.workbench.common.screens.archetype.mgmt.backend.maven.AbstractMavenCommand;
import org.kie.workbench.common.screens.archetype.mgmt.backend.maven.ArchetypeGenerateCommand;
import org.kie.workbench.common.screens.archetype.mgmt.backend.maven.BuildProjectCommand;
import org.kie.workbench.common.screens.archetype.mgmt.backend.preference.ArchetypePreferencesManager;
import org.kie.workbench.common.screens.archetype.mgmt.backend.util.ArchetypeListingPredicates;
import org.kie.workbench.common.screens.archetype.mgmt.shared.events.ArchetypeListUpdatedEvent;
import org.kie.workbench.common.screens.archetype.mgmt.shared.exceptions.ArchetypeAlreadyExistsException;
import org.kie.workbench.common.screens.archetype.mgmt.shared.exceptions.InvalidArchetypeException;
import org.kie.workbench.common.screens.archetype.mgmt.shared.exceptions.MavenExecutionException;
import org.kie.workbench.common.screens.archetype.mgmt.shared.model.Archetype;
import org.kie.workbench.common.screens.archetype.mgmt.shared.model.ArchetypeListOperation;
import org.kie.workbench.common.screens.archetype.mgmt.shared.model.ArchetypeStatus;
import org.kie.workbench.common.screens.archetype.mgmt.shared.model.PaginatedArchetypeList;
import org.kie.workbench.common.screens.archetype.mgmt.shared.services.ArchetypeService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.api.FileSystemUtils;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.fs.jgit.FileSystemLock;
import org.uberfire.java.nio.fs.jgit.FileSystemLockManager;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;

@Startup
@Service
@ApplicationScoped
public class ArchetypeServiceImpl
implements ArchetypeService {
    protected static final String BASE_KIE_PROJECT_TEMPLATE_GAV = "org.kie.templates:base-kie-project:1.0.0-TEMPLATE";
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchetypeServiceImpl.class);
    private static final String ALIAS_PARAM = "alias";
    private static final String DEFAULT_GROUP_ID = "org.kie.archetypes";
    private static final String LOCK_NAME = "archetype.lock";
    private static final int LAST_ACCESS_THRESHOLD = 1;
    private static final String TEMPLATE = "TEMPLATE";
    private static final String TEMPLATE_SUFFIX = "-TEMPLATE";
    private static final String REMOTE_ORIGIN_REF = "refs/remotes/origin/master";
    private static final String ORIGIN_KEY = "origin";
    private static final String SYSTEM = "system";
    private static final String KIE_TEMPLATES = "kie-wb-common-archetype-mgmt-templates";
    private static final String KIE_TEMPLATES_ZIP = "org/kie/kie-wb-common-archetype-mgmt-templates/kie-wb-common-archetype-mgmt-templates.zip";
    private IOService ioService;
    private RepositoryService repositoryService;
    private OrganizationalUnitService ouService;
    private Event<ArchetypeListUpdatedEvent> archetypeListUpdatedEvent;
    private ArchetypeConfigStorage archetypeConfigStorage;
    private PathUtil pathUtil;
    private ArchetypePreferencesManager archetypePreferencesManager;
    private KieModuleService moduleService;
    private POMService pomService;
    private boolean isSpaceSetup = false;

    public ArchetypeServiceImpl() {
    }

    @Inject
    public ArchetypeServiceImpl(@Named(value="ioStrategy") IOService ioService, RepositoryService repositoryService, OrganizationalUnitService ouService, Event<ArchetypeListUpdatedEvent> archetypeListUpdatedEvent, ArchetypeConfigStorage archetypeConfigStorage, PathUtil pathUtil, ArchetypePreferencesManager archetypePreferencesManager, KieModuleService moduleService, POMService pomService) {
        this.ioService = ioService;
        this.repositoryService = repositoryService;
        this.ouService = ouService;
        this.archetypeListUpdatedEvent = archetypeListUpdatedEvent;
        this.archetypeConfigStorage = archetypeConfigStorage;
        this.pathUtil = pathUtil;
        this.archetypePreferencesManager = archetypePreferencesManager;
        this.moduleService = moduleService;
        this.pomService = pomService;
    }

    private static String composeSearchableElement(Archetype element) {
        return element.getAlias().toLowerCase();
    }

    @PostConstruct
    void postConstruct() {
        if (this.isGitDefaultFileSystem()) {
            this.maybeCreateArchetypesOU();
            if (this.isArchetypesOUAvailable()) {
                this.archetypePreferencesManager.initializeCustomPreferences();
                this.checkKieTemplates();
                this.validateAll();
            }
        }
    }

    protected boolean isGitDefaultFileSystem() {
        return FileSystemUtils.isGitDefaultFileSystem();
    }

    public void onNewOrganizationalUnitEvent(@Observes NewOrganizationalUnitEvent newOrganizationalUnitEvent) {
        OrganizationalUnit newOU = newOrganizationalUnitEvent.getOrganizationalUnit();
        if (this.isArchetypesOUAvailable() && !newOU.getName().equals(".archetypes")) {
            this.archetypePreferencesManager.initializeCustomPreference(newOU.getIdentifier());
        }
    }

    public void add(GAV archetypeGav) {
        PortablePreconditions.checkNotNull((String)"archetypeGav", (Object)archetypeGav);
        this.add(archetypeGav, this.copyGav(archetypeGav));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(GAV archetypeGav, GAV templateGav) {
        PortablePreconditions.checkNotNull((String)"archetypeGav", (Object)archetypeGav);
        PortablePreconditions.checkNotNull((String)"templateGav", (Object)templateGav);
        this.appendTemplateSuffix(templateGav);
        this.checkArchetypeAlreadyAdded(templateGav);
        Path workingDirectoryPath = this.createTempDirectory(templateGav.getArtifactId());
        File workingDirectory = new File(workingDirectoryPath.toString());
        FileSystemLock physicalLock = this.createLock(workingDirectory);
        try {
            physicalLock.lock();
            this.executeMaven(new ArchetypeGenerateCommand(workingDirectoryPath.toString(), archetypeGav, templateGav));
            this.checkModuleValid(workingDirectoryPath.resolve(templateGav.getArtifactId()));
            this.finishAddExternalArchetype(templateGav, workingDirectory);
        }
        catch (MavenEmbedderException | GitAPIException e) {
            LOGGER.error(String.format("Failed to add the archetype %s", templateGav), e);
        }
        finally {
            physicalLock.unlock();
        }
    }

    public PaginatedArchetypeList list(Integer page, Integer pageSize, String filter) {
        PortablePreconditions.checkNotNull((String)"page", (Object)page);
        PortablePreconditions.checkNotNull((String)"pageSize", (Object)pageSize);
        List<Archetype> archetypes = this.listFilteredArchetypes(this.matchNotInternalRepositories(), ArchetypeListingPredicates.matchSearchFilter(filter, ArchetypeServiceImpl::composeSearchableElement));
        return this.finishListArchetypes(archetypes, page, pageSize);
    }

    public PaginatedArchetypeList list(Integer page, Integer pageSize, String filter, ArchetypeStatus status) {
        PortablePreconditions.checkNotNull((String)"page", (Object)page);
        PortablePreconditions.checkNotNull((String)"pageSize", (Object)pageSize);
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        List<Archetype> archetypes = this.listFilteredArchetypes(this.matchNotInternalRepositories(), ArchetypeListingPredicates.matchSearchFilterAndStatus(filter, ArchetypeServiceImpl::composeSearchableElement, status));
        return this.finishListArchetypes(archetypes, page, pageSize);
    }

    public void delete(String alias) {
        PortablePreconditions.checkNotEmpty((String)ALIAS_PARAM, (String)alias);
        OrganizationalUnit archetypesOU = this.resolveOU();
        if (archetypesOU == null) {
            throw new IllegalStateException("Cannot delete an archetype when there is no archetype space available.");
        }
        this.repositoryService.removeRepository(archetypesOU.getSpace(), alias);
        this.archetypeConfigStorage.deleteArchetype(alias);
        this.archetypePreferencesManager.removeArchetype(alias);
        this.archetypeListUpdatedEvent.fire((Object)new ArchetypeListUpdatedEvent(ArchetypeListOperation.DELETE));
        LOGGER.info("Archetype {} successfully deleted.", (Object)alias);
    }

    public void validateAll() {
        this.getRepositories(this.matchAllRepositories()).forEach(item -> {
            this.validateArchetype((Repository)item);
            Archetype archetype = this.archetypeConfigStorage.loadArchetype(item.getAlias());
            if (archetype.isInternal().equals(Boolean.FALSE)) {
                this.archetypePreferencesManager.addArchetype(archetype.getAlias());
            }
        });
    }

    public void validate(String alias) {
        PortablePreconditions.checkNotEmpty((String)ALIAS_PARAM, (String)alias);
        Repository repository = this.resolveRepository(alias);
        if (repository == null) {
            throw new IllegalStateException(String.format("Repository %s cannot be resolved.", alias));
        }
        this.validateArchetype(repository);
        this.archetypePreferencesManager.addArchetype(alias);
        this.archetypeListUpdatedEvent.fire((Object)new ArchetypeListUpdatedEvent(ArchetypeListOperation.VALIDATE));
    }

    public Repository getTemplateRepository(String alias) {
        PortablePreconditions.checkNotEmpty((String)ALIAS_PARAM, (String)alias);
        Repository repository = this.resolveRepository(alias);
        if (repository != null) {
            this.checkTemplateShouldBeValid(alias);
            return repository;
        }
        throw new IllegalStateException(String.format("Repository %s cannot be resolved.", alias));
    }

    public Optional<Repository> getBaseKieTemplateRepository() {
        Optional<Archetype> archetype = this.getBaseKieArchetype();
        if (!archetype.isPresent()) {
            LOGGER.warn("The base kie project template is not registered.");
            return Optional.empty();
        }
        if (archetype.get().getStatus() != ArchetypeStatus.VALID) {
            LOGGER.warn("The state of base kie project template is invalid.");
            return Optional.empty();
        }
        String repositoryAlias = this.makeRepositoryAlias(BASE_KIE_PROJECT_TEMPLATE_GAV);
        return Optional.ofNullable(this.resolveRepository(repositoryAlias));
    }

    public Optional<Archetype> getBaseKieArchetype() {
        String repositoryAlias = this.makeRepositoryAlias(BASE_KIE_PROJECT_TEMPLATE_GAV);
        Archetype archetype = this.archetypeConfigStorage.loadArchetype(repositoryAlias);
        if (archetype == null) {
            LOGGER.warn("The base kie project archetype is not registered.");
        }
        return Optional.ofNullable(archetype);
    }

    private void checkTemplateShouldBeValid(String alias) {
        Archetype archetype = this.archetypeConfigStorage.loadArchetype(alias);
        if (archetype.getStatus() != ArchetypeStatus.VALID) {
            throw new IllegalStateException(String.format("Template repository %s is invalid, thus cannot be used.", alias));
        }
    }

    private GAV copyGav(GAV original) {
        return new GAV(original.getGroupId(), original.getArtifactId(), original.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkKieTemplates() {
        block16: {
            URL zipResource = this.getClass().getClassLoader().getResource(KIE_TEMPLATES_ZIP);
            if (zipResource == null) {
                LOGGER.warn("Kie templates could not be found at: {}", (Object)KIE_TEMPLATES_ZIP);
                return;
            }
            Path kieTemplatesPath = this.createTempDirectory(KIE_TEMPLATES);
            File kieTemplatesDirectory = new File(kieTemplatesPath.toString());
            FileSystemLock physicalLock = this.createLock(kieTemplatesDirectory);
            try {
                physicalLock.lock();
                boolean unzipSucceeded = this.unzipFile(zipResource, kieTemplatesDirectory);
                if (!unzipSucceeded) break block16;
                try (DirectoryStream directoryStream = this.ioService.newDirectoryStream(kieTemplatesPath, x$0 -> Files.isDirectory((Path)x$0, (LinkOption[])new LinkOption[0]));){
                    directoryStream.forEach(path -> {
                        org.uberfire.backend.vfs.Path templatePomPath = this.pathUtil.convert(path.resolve("pom.xml"));
                        GAV templateGav = ((POM)this.pomService.load(templatePomPath)).getGav();
                        this.addInternalTemplate((Path)path, templateGav);
                    });
                }
            }
            finally {
                physicalLock.unlock();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean unzipFile(URL zipResource, File destinationDirectory) {
        try (ZipInputStream zis = new ZipInputStream(zipResource.openStream());){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                FileOutputStream fos;
                block26: {
                    byte[] buffer = new byte[1024];
                    File file = new File(destinationDirectory, zipEntry.getName());
                    if (zipEntry.isDirectory()) {
                        file.mkdirs();
                        continue;
                    }
                    fos = new FileOutputStream(file);
                    Throwable throwable = null;
                    try {
                        int read;
                        while ((read = zis.read(buffer)) != -1) {
                            fos.write(buffer, 0, read);
                        }
                        if (fos == null) continue;
                        if (throwable == null) break block26;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (fos == null) throw throwable3;
                            if (throwable == null) {
                                fos.close();
                                throw throwable3;
                            }
                            try {
                                fos.close();
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                    }
                    try {
                        fos.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                fos.close();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error(String.format("Failed to unzip the file %s", destinationDirectory), (Throwable)e);
            return false;
        }
    }

    private void addInternalTemplate(Path workingDirectoryPath, GAV templateGav) {
        try {
            this.appendTemplateSuffix(templateGav);
            this.checkArchetypeAlreadyAdded(templateGav);
            File workingDirectory = new File(workingDirectoryPath.toString());
            this.checkModuleValid(workingDirectoryPath.resolve(templateGav.getArtifactId()));
            this.finishAddArchetype(templateGav, workingDirectory, true);
        }
        catch (ArchetypeAlreadyExistsException workingDirectory) {
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to add internal template %s", templateGav.toString()), (Throwable)e);
        }
    }

    private void appendTemplateSuffix(GAV gav) {
        gav.setVersion(gav.getVersion() + TEMPLATE_SUFFIX);
    }

    private PaginatedArchetypeList finishListArchetypes(List<Archetype> archetypes, int page, int pageSize) {
        List<Archetype> paginatedArchetypes = this.paginateArchetypes(archetypes, page, pageSize);
        return new PaginatedArchetypeList(paginatedArchetypes, Integer.valueOf(page), Integer.valueOf(pageSize), Integer.valueOf(archetypes.size()));
    }

    private void checkModuleValid(Path modulePath) {
        boolean isValid;
        boolean bl = isValid = this.moduleService.resolveModule(this.pathUtil.convert(modulePath)) != null;
        if (!isValid) {
            throw new InvalidArchetypeException();
        }
    }

    private void validateArchetype(Repository repository) {
        try {
            LOGGER.info("Validating the archetype: {}", (Object)repository.getAlias());
            Path targetDirectoryPath = this.unpackArchetype(repository);
            this.executeMaven(new BuildProjectCommand(targetDirectoryPath.toString()));
            this.updateArchetypeStatus(repository.getAlias(), ArchetypeStatus.VALID, null);
            boolean onlyOneAvailable = this.getRepositories(this.matchNotInternalRepositories()).size() == 1;
            this.archetypePreferencesManager.enableArchetype(repository.getAlias(), true, onlyOneAvailable);
            if (onlyOneAvailable) {
                this.archetypePreferencesManager.setDefaultArchetype(repository.getAlias());
            }
            LOGGER.info("Archetype repository {} successfully validated.", (Object)repository.getAlias());
        }
        catch (Exception e) {
            this.updateArchetypeStatus(repository.getAlias(), ArchetypeStatus.INVALID, e.getMessage());
            this.archetypePreferencesManager.enableArchetype(repository.getAlias(), false, true);
            LOGGER.error(String.format("Failed to validate the repository %s", repository.getAlias()), (Throwable)e);
        }
    }

    private void finishAddExternalArchetype(GAV templateGav, File workingDirectory) throws GitAPIException, MavenEmbedderException {
        File repositoryDirectory = new File(workingDirectory, templateGav.getArtifactId());
        Archetype archetype = this.finishAddArchetype(templateGav, repositoryDirectory, false);
        this.archetypePreferencesManager.addArchetype(archetype.getAlias());
        this.archetypeListUpdatedEvent.fire((Object)new ArchetypeListUpdatedEvent(ArchetypeListOperation.ADD));
    }

    private Archetype finishAddArchetype(GAV templateGav, File repositoryDirectory, boolean internal) throws GitAPIException, MavenEmbedderException {
        Repository repository = this.makeArchetypeAvailable(templateGav, repositoryDirectory);
        Archetype archetype = new Archetype(repository.getAlias(), templateGav, new Date(), ArchetypeStatus.VALID, Boolean.valueOf(internal));
        this.archetypeConfigStorage.saveArchetype(archetype);
        LOGGER.info("Archetype {} successfully added.", (Object)templateGav);
        return archetype;
    }

    private void updateArchetypeStatus(String alias, ArchetypeStatus status, String message) {
        Archetype archetype = this.archetypeConfigStorage.loadArchetype(alias);
        Archetype updatedArchetype = new Archetype(archetype.getAlias(), archetype.getGav(), archetype.getCreatedDate(), status, message, archetype.isInternal());
        this.archetypeConfigStorage.saveArchetype(updatedArchetype);
    }

    private List<Archetype> paginateArchetypes(List<Archetype> archetypes, int page, int pageSize) {
        if (pageSize == 0) {
            return archetypes;
        }
        Map<Integer, List> map = IntStream.iterate(0, i -> i + pageSize).limit((archetypes.size() + pageSize - 1) / pageSize).boxed().collect(Collectors.toMap(i -> i / pageSize, i -> archetypes.subList((int)i, Integer.min(i + pageSize, archetypes.size()))));
        return new ArrayList<Archetype>((Collection)map.getOrDefault(page, archetypes));
    }

    private Collection<Repository> getRepositories(Predicate<Repository> filter) {
        OrganizationalUnit archetypesOU = this.resolveOU();
        if (archetypesOU != null) {
            return this.repositoryService.getAllRepositories(archetypesOU.getSpace()).stream().filter(filter).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Repository resolveRepository(String alias) {
        OrganizationalUnit archetypesOU = this.resolveOU();
        if (archetypesOU != null) {
            return this.repositoryService.getRepositoryFromSpace(archetypesOU.getSpace(), alias);
        }
        String errorMsg = String.format("Cannot resolve the repository <%s> when there is no archetype space available.", alias);
        throw new IllegalStateException(errorMsg);
    }

    private OrganizationalUnit resolveOU() {
        OrganizationalUnit archetypesOU = this.ouService.getOrganizationalUnit(".archetypes");
        if (archetypesOU != null && !this.isSpaceSetup) {
            this.archetypeConfigStorage.setup();
            this.isSpaceSetup = true;
        }
        return archetypesOU;
    }

    private Branch resolveDefaultBranch(Repository repository) {
        return (Branch)repository.getDefaultBranch().orElseThrow(() -> new IllegalStateException("There is no default branch for  " + repository.getAlias()));
    }

    private File resolveRepositoryDirectory(Repository repository) {
        org.uberfire.java.nio.fs.jgit.util.Git git = this.getGitFromRepository(repository);
        return git.getRepository().getDirectory();
    }

    private List<Archetype> listFilteredArchetypes(Predicate<Repository> repositoryPredicate, Predicate<Archetype> archetypePredicate) {
        return this.getRepositories(repositoryPredicate).stream().map(repository -> this.archetypeConfigStorage.loadArchetype(repository.getAlias())).filter(archetypePredicate).sorted(Comparator.comparing(Archetype::getAlias)).collect(Collectors.toList());
    }

    private void checkArchetypeAlreadyAdded(GAV templateGav) {
        ArrayList<Archetype> archetypes = new ArrayList<Archetype>(this.listFilteredArchetypes(this.matchAllRepositories(), ArchetypeListingPredicates.matchGav(templateGav)));
        if (!archetypes.isEmpty()) {
            throw new ArchetypeAlreadyExistsException();
        }
    }

    private Repository makeArchetypeAvailable(GAV templateGav, File repositoryDirectory) throws GitAPIException, MavenEmbedderException {
        this.createTemporaryGitRepository(repositoryDirectory);
        this.executeMaven(new BuildProjectCommand(repositoryDirectory.getAbsolutePath()));
        return this.createArchetypeRepository(templateGav, repositoryDirectory.toURI().toString());
    }

    private void maybeCreateArchetypesOU() {
        if (!this.isArchetypesOUAvailable()) {
            this.ouService.createOrganizationalUnit(".archetypes", DEFAULT_GROUP_ID);
            this.archetypeConfigStorage.setup();
            this.isSpaceSetup = true;
        }
    }

    private RepositoryEnvironmentConfigurations createRepositoryConfig(String repositoryUri) {
        RepositoryEnvironmentConfigurations configurations = new RepositoryEnvironmentConfigurations();
        configurations.setInit(false);
        configurations.setOrigin(repositoryUri);
        configurations.setMirror(false);
        configurations.setAvoidIndex(true);
        return configurations;
    }

    private void cleanUpOrigin(Repository repository) {
        Branch defaultBranch = this.resolveDefaultBranch(repository);
        org.uberfire.java.nio.fs.jgit.util.Git git = this.getGitFromBranch(defaultBranch);
        git.removeRemote(ORIGIN_KEY, REMOTE_ORIGIN_REF);
    }

    private boolean isArchetypesOUAvailable() {
        Predicate<OrganizationalUnit> archetypesFilter = ou -> ou.getName().equals(".archetypes");
        return !this.ouService.getAllOrganizationalUnits(false, archetypesFilter).isEmpty();
    }

    private Predicate<Repository> matchInternalRepositories() {
        return repository -> this.archetypeConfigStorage.loadArchetype(repository.getAlias()).isInternal();
    }

    private Predicate<Repository> matchNotInternalRepositories() {
        return this.matchInternalRepositories().negate();
    }

    private Predicate<Repository> matchAllRepositories() {
        return repository -> true;
    }

    Path unpackArchetype(Repository repository) {
        try {
            Path targetDirectoryPath = this.createTempDirectory(TEMPLATE);
            File targetDirectory = new File(targetDirectoryPath.toString());
            File repositoryDirectory = this.resolveRepositoryDirectory(repository);
            this.cloneRepository(repositoryDirectory, targetDirectory.getAbsoluteFile());
            return targetDirectoryPath;
        }
        catch (Exception e) {
            String msg = String.format("Failed to unpack the repository %s", repository.getAlias());
            LOGGER.error(msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
    }

    Repository createArchetypeRepository(GAV templateGav, String repositoryUri) {
        OrganizationalUnit archetypesOU = this.resolveOU();
        if (archetypesOU != null) {
            Repository repository = this.repositoryService.createRepository(archetypesOU, GitRepository.SCHEME.toString(), this.makeRepositoryAlias(templateGav.toString()), this.createRepositoryConfig(repositoryUri));
            this.cleanUpOrigin(repository);
            return repository;
        }
        throw new IllegalStateException("Cannot create an archetype when there is no archetype space available.");
    }

    String makeRepositoryAlias(String gavString) {
        return gavString.replaceAll("[.:]", "-");
    }

    void throwMavenExecutionException(List<Throwable> exceptions) {
        if (exceptions.isEmpty()) {
            throw new MavenExecutionException();
        }
        String message = exceptions.stream().map(Throwable::getMessage).collect(Collectors.joining(","));
        throw new MavenExecutionException(message);
    }

    void executeMaven(AbstractMavenCommand command) throws MavenEmbedderException {
        MavenExecutionResult result = command.execute();
        if (result.hasExceptions()) {
            this.throwMavenExecutionException(result.getExceptions());
        }
    }

    FileSystemLock createLock(File directory) {
        return FileSystemLockManager.getInstance().getFileSystemLock(directory, LOCK_NAME, TimeUnit.SECONDS, 1L);
    }

    void cloneRepository(File repositoryDirectory, File destinationDirectory) throws GitAPIException {
        Git.cloneRepository().setURI(repositoryDirectory.toURI().toString()).setDirectory(destinationDirectory).call();
    }

    Path createTempDirectory(String path) {
        return Files.createTempDirectory((String)path, (FileAttribute[])new FileAttribute[0]);
    }

    void createTemporaryGitRepository(File repositoryDirectory) throws GitAPIException {
        Git git = Git.init().setBare(false).setDirectory(repositoryDirectory).call();
        git.add().addFilepattern(".").call();
        git.commit().setMessage("Initial commit").setAuthor(SYSTEM, SYSTEM).call();
    }

    org.uberfire.java.nio.fs.jgit.util.Git getGitFromBranch(Branch branch) {
        return ((JGitFileSystem)((JGitPathImpl)this.pathUtil.convert(branch.getPath())).getFileSystem()).getGit();
    }

    org.uberfire.java.nio.fs.jgit.util.Git getGitFromRepository(Repository repository) {
        return this.getGitFromBranch(this.resolveDefaultBranch(repository));
    }
}

