/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.util;

import org.kie.workbench.common.services.datamodeller.util.PortableStringUtils;

public class NamingUtils {
    public static String extractClassName(String fullClassName) {
        if (fullClassName == null) {
            return null;
        }
        int index = fullClassName.lastIndexOf(".");
        if (index > 0) {
            return fullClassName.substring(index + 1, fullClassName.length());
        }
        return fullClassName;
    }

    public static String extractPackageName(String fullClassName) {
        if (fullClassName == null) {
            return null;
        }
        int index = fullClassName.lastIndexOf(".");
        if (index > 0) {
            return fullClassName.substring(0, index);
        }
        return null;
    }

    public static boolean isPrimitiveTypeClass(String className) {
        return Byte.class.getName().equals(className) || Short.class.getName().equals(className) || Integer.class.getName().equals(className) || Long.class.getName().equals(className) || Float.class.getName().equals(className) || Double.class.getName().equals(className) || Character.class.getName().equals(className) || Boolean.class.getName().equals(className);
    }

    public static boolean isPrimitiveTypeId(String type) {
        return "byte".equals(type) || "short".equals(type) || "int".equals(type) || "long".equals(type) || "float".equals(type) || "double".equals(type) || "char".equals(type) || "boolean".equals(type);
    }

    public static boolean isByteId(String type) {
        return "byte".equals(type != null ? type.trim() : type);
    }

    public static boolean isCharId(String type) {
        return "char".equals(type != null ? type.trim() : type);
    }

    public static boolean isLongId(String type) {
        return "long".equals(type != null ? type.trim() : type);
    }

    public static boolean isFloatId(String type) {
        return "float".equals(type != null ? type.trim() : type);
    }

    public static boolean isDoubleId(String type) {
        return "float".equals(type != null ? type.trim() : type);
    }

    public static boolean isQualifiedName(String type) {
        String[] tokens = NamingUtils.tokenizeClassName(type);
        return tokens != null && tokens.length > 1;
    }

    public static String[] tokenizeClassName(String className) {
        String[] result = null;
        if (className != null) {
            result = className.split("\\.");
        }
        return result;
    }

    public static String createQualifiedName(String packageName, String className) {
        if (packageName != null && !"".equals(packageName)) {
            return packageName + "." + className;
        }
        return className;
    }

    public static Object parsePrimitiveValue(String type, String value) throws NumberFormatException {
        if (value == null) {
            return null;
        }
        if ("byte".equals(type)) {
            return Byte.valueOf(value);
        }
        if ("short".equals(type)) {
            return Short.valueOf(value);
        }
        if ("int".equals(type)) {
            return Integer.valueOf(value);
        }
        if ("long".equals(type)) {
            return NamingUtils.parseLongValue(value);
        }
        if ("float".equals(type)) {
            return NamingUtils.parseFloatValue(value);
        }
        if ("double".equals(type)) {
            return NamingUtils.parseDoubleValue(value);
        }
        if ("char".equals(type)) {
            return NamingUtils.parseCharValue(value);
        }
        if ("boolean".equals(type)) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public static String parseCharValue(String value) {
        return value;
    }

    public static Long parseLongValue(String value) {
        String trimmedValue = PortableStringUtils.removeLastChar(value != null ? value.trim() : null, 'L');
        if (trimmedValue == null || "".equals(trimmedValue)) {
            return null;
        }
        return Long.valueOf(trimmedValue);
    }

    public static Float parseFloatValue(String value) {
        String trimmedValue = PortableStringUtils.removeLastChar(value != null ? value.trim() : null, 'f');
        if (trimmedValue == null || "".equals(trimmedValue)) {
            return null;
        }
        return Float.valueOf(trimmedValue);
    }

    public static Double parseDoubleValue(String value) {
        String trimmedValue = PortableStringUtils.removeLastChar(value != null ? value.trim() : null, 'd');
        if (trimmedValue == null || "".equals(trimmedValue)) {
            return null;
        }
        return Double.valueOf(trimmedValue);
    }

    public static String normalizeClassName(String className) {
        if (className != null && className.contains("$")) {
            return className.replace("$", ".");
        }
        return className;
    }
}

