/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.backend.storage.migration;

import com.thoughtworks.xstream.XStream;
import java.util.HashMap;
import java.util.Set;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.controller.api.ModelFactory;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.Path;

public class ServerTemplateMigration {
    private static final Logger logger = LoggerFactory.getLogger(ServerTemplateMigration.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrate(Path dir, IOService ioService, XStream xs, KieServerTemplateStorage templateStorage) {
        logger.debug("Attempting to find and migrate 6.2 type kie server templates inside directory '{}'...", (Object)dir);
        try {
            ioService.startBatch(dir.getFileSystem());
            for (Path path : ioService.newDirectoryStream(dir, (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

                public boolean accept(Path entry) throws IOException {
                    return entry.toString().endsWith("-info.xml");
                }
            })) {
                logger.debug("Found 6.2 type kie server template file '{}', migrating it...", (Object)path);
                try {
                    Set instanceInfos;
                    KieServerInstance kieServerInstance = (KieServerInstance)xs.fromXML(ioService.readAllString(path));
                    logger.debug("Loaded KieServerInstance {}", (Object)kieServerInstance);
                    ServerTemplate serverTemplate = new ServerTemplate();
                    serverTemplate.setId(kieServerInstance.getIdentifier());
                    serverTemplate.setName(kieServerInstance.getName());
                    KieServerSetup serverSetup = kieServerInstance.getKieServerSetup();
                    if (serverSetup != null) {
                        Set containerResources = kieServerInstance.getKieServerSetup().getContainers();
                        logger.debug("Server with id {} has containers {}", (Object)kieServerInstance.getIdentifier(), (Object)containerResources);
                        if (containerResources != null) {
                            for (KieContainerResource containerRef : containerResources) {
                                ContainerSpec containerSpec = new ContainerSpec(containerRef.getContainerId(), containerRef.getContainerId(), (ServerTemplateKey)serverTemplate, containerRef.getReleaseId(), containerRef.getStatus(), new HashMap());
                                logger.debug("Migrating container '{}' to container spec '{}'", (Object)containerRef, (Object)containerSpec);
                                serverTemplate.addContainerSpec(containerSpec);
                            }
                        }
                    }
                    if ((instanceInfos = kieServerInstance.getManagedInstances()) != null) {
                        logger.debug("Server with id {} has server instances {}", (Object)kieServerInstance.getIdentifier(), (Object)instanceInfos);
                        for (KieServerInstanceInfo instanceInfo : instanceInfos) {
                            logger.debug("Migrating server instance '{}'", (Object)instanceInfo);
                            serverTemplate.addServerInstance(ModelFactory.newServerInstanceKey((String)serverTemplate.getId(), (String)instanceInfo.getLocation()));
                            serverTemplate.setCapabilities(instanceInfo.getCapabilities());
                        }
                    }
                    logger.debug("About to store migrated server template {}", (Object)serverTemplate);
                    templateStorage.store(serverTemplate);
                    logger.info("Server template {} migrated successfully, removing old version...", (Object)serverTemplate);
                    try {
                        ioService.startBatch(path.getFileSystem());
                        ioService.delete(path, new DeleteOption[0]);
                    }
                    finally {
                        ioService.endBatch();
                    }
                    logger.debug("Old version of server template '{}' has been removed", (Object)kieServerInstance);
                }
                catch (Exception ex) {
                    logger.error("Error while migrating old version (6.2.) of kie server instance from path {}", (Object)path, (Object)ex);
                }
            }
        }
        catch (NotDirectoryException ignore) {
            logger.debug("No directory found, ignoring migration of kie server templates");
        }
        finally {
            ioService.endBatch();
        }
    }
}

