/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.Serializable;
import java.util.Collection;
import java.util.TreeMap;

public class RangeIndex<K extends Comparable, V>
implements Serializable {
    private final TreeMap<IndexKey<K>, V> map = new TreeMap();

    public V addIndex(IndexType indexType, K key, V value) {
        return this.map.put(new IndexKey<K>(indexType, key), value);
    }

    public void removeIndex(IndexType indexType, K key) {
        this.map.remove(new IndexKey<K>(indexType, key));
    }

    public Collection<V> getValues(K key) {
        return this.map.subMap(new IndexKey<K>(IndexType.LT, key), false, new IndexKey<K>(IndexType.GT, key), false).values();
    }

    public Collection<V> getAllValues() {
        return this.map.values();
    }

    private static class IndexKey<K extends Comparable>
    implements Comparable<IndexKey<K>>,
    Serializable {
        private final IndexType indexType;
        private final K key;

        public IndexKey(IndexType indexType, K key) {
            this.indexType = indexType;
            this.key = key;
        }

        @Override
        public int compareTo(IndexKey<K> o) {
            int directionDiff = this.indexType.direction - o.indexType.direction;
            if (directionDiff != 0) {
                return directionDiff;
            }
            int orderDiff = this.key.compareTo(o.key);
            return orderDiff != 0 ? orderDiff : this.indexType.compareTo(o.indexType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.indexType == null ? 0 : this.indexType.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexKey other = (IndexKey)obj;
            if (this.indexType != other.indexType) {
                return false;
            }
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }

    public static enum IndexType {
        LT(0),
        LE(0),
        GE(1),
        GT(1);

        private int direction;

        private IndexType(int direction) {
            this.direction = direction;
        }
    }
}

