/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filters;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.filters.FiltersAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;

public class FiltersAggregatorFactory
extends AggregatorFactory<FiltersAggregatorFactory> {
    private final String[] keys;
    private final Query[] filters;
    private Weight[] weights;
    private final boolean keyed;
    private final boolean otherBucket;
    private final String otherBucketKey;

    public FiltersAggregatorFactory(String name, List<FiltersAggregator.KeyedFilter> filters, boolean keyed, boolean otherBucket, String otherBucketKey, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactories, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, subFactories, metaData);
        this.keyed = keyed;
        this.otherBucket = otherBucket;
        this.otherBucketKey = otherBucketKey;
        this.keys = new String[filters.size()];
        this.filters = new Query[filters.size()];
        for (int i = 0; i < filters.size(); ++i) {
            FiltersAggregator.KeyedFilter keyedFilter = filters.get(i);
            this.keys[i] = keyedFilter.key();
            this.filters[i] = keyedFilter.filter().toFilter(context.getQueryShardContext());
        }
    }

    public Weight[] getWeights() {
        if (this.weights == null) {
            try {
                ContextIndexSearcher contextSearcher = this.context.searcher();
                this.weights = new Weight[this.filters.length];
                for (int i = 0; i < this.filters.length; ++i) {
                    this.weights[i] = contextSearcher.createNormalizedWeight(this.filters[i], false);
                }
            }
            catch (IOException e) {
                throw new AggregationInitializationException("Failed to initialse filters for aggregation [" + this.name() + "]", e);
            }
        }
        return this.weights;
    }

    @Override
    public Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new FiltersAggregator(this.name, this.factories, this.keys, () -> this.getWeights(), this.keyed, this.otherBucket ? this.otherBucketKey : null, this.context, parent, pipelineAggregators, metaData);
    }
}

