/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.storage.scoped.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefinition;
import org.uberfire.experimental.service.events.PortableExperimentalFeatureModifiedEvent;
import org.uberfire.experimental.service.registry.ExperimentalFeature;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.storage.scoped.ExperimentalStorageScope;
import org.uberfire.experimental.service.storage.scoped.impl.AbstractScopedExperimentalFeaturesStorage;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.rpc.SessionInfo;

@Dependent
public class GlobalExperimentalFeaturesStorageImpl
extends AbstractScopedExperimentalFeaturesStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalExperimentalFeaturesStorageImpl.class);
    public static final String GLOBAL_STORAGE_PATH = "/experimental/global/.experimental";
    private Event<PortableExperimentalFeatureModifiedEvent> event;
    private List<ExperimentalFeatureImpl> globalFeatures;

    @Inject
    public GlobalExperimentalFeaturesStorageImpl(SessionInfo sessionInfo, @Named(value="configIO") IOService ioService, ExperimentalFeatureDefRegistry defRegistry, Event<PortableExperimentalFeatureModifiedEvent> event) {
        super(sessionInfo, ioService, defRegistry);
        this.event = event;
    }

    @Override
    public void init(FileSystem fileSystem) {
        super.init(fileSystem);
        this.loadGlobalFeatures();
    }

    protected void loadGlobalFeatures() {
        this.globalFeatures = Collections.unmodifiableList(new ArrayList<ExperimentalFeatureImpl>(this.readFeatures()));
    }

    @Override
    protected Collection<ExperimentalFeatureDefinition> getSupportedDefinitions() {
        return this.defRegistry.getGlobalFeatures();
    }

    @Override
    public Collection<ExperimentalFeatureImpl> getFeatures() {
        return this.globalFeatures;
    }

    @Override
    public String getStoragePath() {
        return GLOBAL_STORAGE_PATH;
    }

    @Override
    protected Logger log() {
        return LOGGER;
    }

    @Override
    protected void maybeNotifyFeatureUpdate(ExperimentalFeatureImpl feature) {
        this.event.fire((Object)new PortableExperimentalFeatureModifiedEvent((ExperimentalFeature)feature));
    }

    @Override
    public ExperimentalStorageScope getScope() {
        return ExperimentalStorageScope.GLOBAL;
    }
}

