/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.tree.TreeModel;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.builders.KiePMMLModelCodegenUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.tree.compiler.factories.KiePMMLNodeFactory;
import org.kie.pmml.models.tree.compiler.utils.KiePMMLTreeModelUtils;
import org.kie.pmml.models.tree.model.KiePMMLTreeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLTreeModelFactory {
    static final String KIE_PMML_TREE_MODEL_TEMPLATE_JAVA = "KiePMMLTreeModelTemplate.tmpl";
    static final String KIE_PMML_TREE_MODEL_TEMPLATE = "KiePMMLTreeModelTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLTreeModelFactory.class.getName());

    private KiePMMLTreeModelFactory() {
    }

    public static KiePMMLTreeModel getKiePMMLTreeModel(List<Field<?>> fields, TransformationDictionary transformationDictionary, TreeModel model, String packageName, HasClassLoader hasClassLoader) {
        logger.trace("getKiePMMLTreeModel {} {}", (Object)packageName, (Object)model);
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        Map<String, String> sourcesMap = KiePMMLTreeModelFactory.getKiePMMLTreeModelSourcesMap(fields, transformationDictionary, model, packageName);
        String fullClassName = packageName + "." + className;
        try {
            Class kiePMMLTreeModelClass = hasClassLoader.compileAndLoadClass(sourcesMap, fullClassName);
            return (KiePMMLTreeModel)kiePMMLTreeModelClass.newInstance();
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public static Map<String, String> getKiePMMLTreeModelSourcesMap(List<Field<?>> fields, TransformationDictionary transformationDictionary, TreeModel model, String packageName) {
        logger.trace("getKiePMMLTreeModelSourcesMap {} {} {}", new Object[]{fields, model, packageName});
        String className = KiePMMLModelUtils.getSanitizedClassName((String)model.getModelName());
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)packageName, (String)KIE_PMML_TREE_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_TREE_MODEL_TEMPLATE);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        Double missingValuePenalty = model.getMissingValuePenalty() != null ? Double.valueOf(model.getMissingValuePenalty().doubleValue()) : null;
        KiePMMLNodeFactory.NodeNamesDTO nodeNamesDTO = new KiePMMLNodeFactory.NodeNamesDTO(model.getNode(), KiePMMLTreeModelUtils.createNodeClassName(), null, missingValuePenalty);
        String fullNodeClassName = packageName + "." + nodeNamesDTO.nodeClassName;
        Map<String, String> toReturn = KiePMMLNodeFactory.getKiePMMLNodeSourcesMap(nodeNamesDTO, fields, packageName);
        KiePMMLTreeModelFactory.setConstructor(model, fields, transformationDictionary, modelTemplate, fullNodeClassName);
        String fullClassName = packageName + "." + className;
        toReturn.put(fullClassName, cloneCU.toString());
        return toReturn;
    }

    static void setConstructor(TreeModel treeModel, List<Field<?>> fields, TransformationDictionary transformationDictionary, ClassOrInterfaceDeclaration modelTemplate, String fullNodeClassName) {
        KiePMMLModelCodegenUtils.init((ClassOrInterfaceDeclaration)modelTemplate, fields, (TransformationDictionary)transformationDictionary, (Model)treeModel);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        BlockStmt body = constructorDeclaration.getBody();
        MethodReferenceExpr nodeReference = new MethodReferenceExpr();
        nodeReference.setScope((Expression)new NameExpr(fullNodeClassName));
        nodeReference.setIdentifier("evaluateNode");
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"nodeFunction", (Expression)nodeReference);
    }
}

