/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.backend.server;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.backend.server.ResourceResolver;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.structure.repositories.Branch;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class ModuleFinder {
    private POMService pomService;
    private IOService ioService;
    private ResourceResolver resourceResolver;

    public ModuleFinder() {
    }

    @Inject
    public ModuleFinder(@Named(value="ioStrategy") IOService ioService, POMService pomService) {
        this.ioService = ioService;
        this.pomService = pomService;
    }

    public Set<Module> find(ResourceResolver resourceResolver, Branch branch) {
        this.resourceResolver = (ResourceResolver)PortablePreconditions.checkNotNull((String)"resourceResolver", (Object)resourceResolver);
        return new Finder((Branch)PortablePreconditions.checkNotNull((String)"branch", (Object)branch)).find();
    }

    private class Finder {
        private final Branch branch;
        private final Set<Module> modules = new HashSet<Module>();

        public Finder(Branch branch) {
            this.branch = branch;
        }

        public Set<Module> find() {
            if (this.branch == null) {
                return this.modules;
            }
            this.findModule(Paths.convert((org.uberfire.backend.vfs.Path)this.branch.getPath()), true);
            return this.modules;
        }

        private void findModule(Path folderPath, boolean checkModulesFromFolders) {
            Path pomPath = folderPath.resolve("pom.xml");
            if (Files.exists((Path)pomPath, (LinkOption[])new LinkOption[0])) {
                Object module = ModuleFinder.this.resourceResolver.resolveModule(Paths.convert((Path)pomPath));
                if (module != null) {
                    this.addModule((Module)module);
                } else if (checkModulesFromFolders) {
                    this.lookForModulesFromFolders(folderPath);
                }
            } else if (checkModulesFromFolders) {
                this.lookForModulesFromFolders(folderPath);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lookForModulesFromFolders(Path folderPath) {
            try (DirectoryStream nioRepositoryPaths = ModuleFinder.this.ioService.newDirectoryStream(folderPath);){
                for (Path nioRepositoryPath : nioRepositoryPaths) {
                    if (!Files.isDirectory((Path)nioRepositoryPath, (LinkOption[])new LinkOption[0])) continue;
                    this.findModule(nioRepositoryPath, false);
                }
            }
        }

        private void addModule(Module module) {
            module.setPom((POM)ModuleFinder.this.pomService.load(module.getPomXMLPath()));
            this.modules.add(module);
        }
    }
}

