/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.EndpointSubsetBuilder;
import io.fabric8.kubernetes.api.model.EndpointSubsetFluentImpl;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class EndpointsFluentImpl<A extends EndpointsFluent<A>>
extends BaseFluent<A>
implements EndpointsFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<EndpointSubsetBuilder> subsets = new ArrayList<EndpointSubsetBuilder>();

    public EndpointsFluentImpl() {
    }

    public EndpointsFluentImpl(Endpoints instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSubsets(instance.getSubsets());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public EndpointsFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public EndpointsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public EndpointsFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public EndpointsFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public EndpointsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToSubsets(int index, EndpointSubset item) {
        if (this.subsets == null) {
            this.subsets = new ArrayList<EndpointSubsetBuilder>();
        }
        EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
        this._visitables.get("subsets").add(index >= 0 ? index : this._visitables.get("subsets").size(), builder);
        this.subsets.add(index >= 0 ? index : this.subsets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubsets(int index, EndpointSubset item) {
        if (this.subsets == null) {
            this.subsets = new ArrayList<EndpointSubsetBuilder>();
        }
        EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
        if (index < 0 || index >= this._visitables.get("subsets").size()) {
            this._visitables.get("subsets").add(builder);
        } else {
            this._visitables.get("subsets").set(index, builder);
        }
        if (index < 0 || index >= this.subsets.size()) {
            this.subsets.add(builder);
        } else {
            this.subsets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubsets(EndpointSubset ... items) {
        if (this.subsets == null) {
            this.subsets = new ArrayList<EndpointSubsetBuilder>();
        }
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.get("subsets").add(builder);
            this.subsets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubsets(Collection<EndpointSubset> items) {
        if (this.subsets == null) {
            this.subsets = new ArrayList<EndpointSubsetBuilder>();
        }
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.get("subsets").add(builder);
            this.subsets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubsets(EndpointSubset ... items) {
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.get("subsets").remove(builder);
            if (this.subsets == null) continue;
            this.subsets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubsets(Collection<EndpointSubset> items) {
        for (EndpointSubset item : items) {
            EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);
            this._visitables.get("subsets").remove(builder);
            if (this.subsets == null) continue;
            this.subsets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSubsets(Predicate<EndpointSubsetBuilder> predicate) {
        if (this.subsets == null) {
            return (A)this;
        }
        Iterator<EndpointSubsetBuilder> each = this.subsets.iterator();
        Object visitables = this._visitables.get("subsets");
        while (each.hasNext()) {
            EndpointSubsetBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EndpointSubset> getSubsets() {
        return EndpointsFluentImpl.build(this.subsets);
    }

    @Override
    public List<EndpointSubset> buildSubsets() {
        return EndpointsFluentImpl.build(this.subsets);
    }

    @Override
    public EndpointSubset buildSubset(int index) {
        return this.subsets.get(index).build();
    }

    @Override
    public EndpointSubset buildFirstSubset() {
        return this.subsets.get(0).build();
    }

    @Override
    public EndpointSubset buildLastSubset() {
        return this.subsets.get(this.subsets.size() - 1).build();
    }

    @Override
    public EndpointSubset buildMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
        for (EndpointSubsetBuilder item : this.subsets) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
        for (EndpointSubsetBuilder item : this.subsets) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubsets(List<EndpointSubset> subsets) {
        if (this.subsets != null) {
            this._visitables.get("subsets").removeAll(this.subsets);
        }
        if (subsets != null) {
            this.subsets = new ArrayList<EndpointSubsetBuilder>();
            for (EndpointSubset item : subsets) {
                this.addToSubsets(item);
            }
        } else {
            this.subsets = null;
        }
        return (A)this;
    }

    @Override
    public A withSubsets(EndpointSubset ... subsets) {
        if (this.subsets != null) {
            this.subsets.clear();
        }
        if (subsets != null) {
            for (EndpointSubset item : subsets) {
                this.addToSubsets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubsets() {
        return this.subsets != null && !this.subsets.isEmpty();
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> addNewSubset() {
        return new SubsetsNestedImpl();
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> addNewSubsetLike(EndpointSubset item) {
        return new SubsetsNestedImpl(-1, item);
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> setNewSubsetLike(int index, EndpointSubset item) {
        return new SubsetsNestedImpl(index, item);
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> editSubset(int index) {
        if (this.subsets.size() <= index) {
            throw new RuntimeException("Can't edit subsets. Index exceeds size.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> editFirstSubset() {
        if (this.subsets.size() == 0) {
            throw new RuntimeException("Can't edit first subsets. The list is empty.");
        }
        return this.setNewSubsetLike(0, this.buildSubset(0));
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> editLastSubset() {
        int index = this.subsets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subsets. The list is empty.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    @Override
    public EndpointsFluent.SubsetsNested<A> editMatchingSubset(Predicate<EndpointSubsetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subsets.size(); ++i) {
            if (!predicate.apply(this.subsets.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subsets. No match found.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointsFluentImpl that = (EndpointsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.subsets != null ? !this.subsets.equals(that.subsets) : that.subsets != null);
    }

    public class SubsetsNestedImpl<N>
    extends EndpointSubsetFluentImpl<EndpointsFluent.SubsetsNested<N>>
    implements EndpointsFluent.SubsetsNested<N>,
    Nested<N> {
        private final EndpointSubsetBuilder builder;
        private final int index;

        SubsetsNestedImpl(int index, EndpointSubset item) {
            this.index = index;
            this.builder = new EndpointSubsetBuilder(this, item);
        }

        SubsetsNestedImpl() {
            this.index = -1;
            this.builder = new EndpointSubsetBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointsFluentImpl.this.setToSubsets(this.index, this.builder.build());
        }

        @Override
        public N endSubset() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<EndpointsFluent.MetadataNested<N>>
    implements EndpointsFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointsFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

