/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.cloud;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.java.nio.IOException;

public interface CloudClientFactory {
    default public OpenShiftClient createOpenShiftClient() {
        return new DefaultOpenShiftClient(this.setupConfig());
    }

    default public KubernetesClient createKubernetesClient() {
        return new DefaultKubernetesClient(this.setupConfig());
    }

    default public Config setupConfig() {
        Logger logger = LoggerFactory.getLogger(CloudClientFactory.class);
        String mainUrl = System.getProperty("kubernetes.master");
        String token = System.getProperty("kubernetes.auth.token");
        if (mainUrl == null) {
            mainUrl = "https://" + System.getenv("KUBERNETES_SERVICE_HOST") + ":" + System.getenv("KUBERNETES_SERVICE_PORT");
            System.setProperty("kubernetes.master", mainUrl);
            logger.debug("mainUrl: {}", (Object)mainUrl);
        }
        if (token == null || token.length() == 0) {
            try {
                token = new String(Files.readAllBytes(Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0])));
            }
            catch (Exception e) {
                logger.error("Load kubenetes oauth token failed.", (Throwable)e);
            }
            if (token == null) {
                throw new IllegalStateException("Kubenetes oauth token missing");
            }
            System.setProperty("kubernetes.auth.token", token);
            logger.debug("Token: [{}]", (Object)token);
        }
        return ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(mainUrl)).withOauthToken(token)).build();
    }

    default public <T extends KubernetesClient, R> Optional<R> executeCloudFunction(Function<T, R> func, Class<T> type) {
        Object result = null;
        try (OpenShiftClient client = type == OpenShiftClient.class ? this.createOpenShiftClient() : this.createKubernetesClient();){
            result = func.apply(client);
        }
        catch (UnsupportedOperationException uoe) {
            throw uoe;
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return Optional.ofNullable(result);
    }
}

