/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.service;

import java.util.Collection;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceRuntimeManager;
import org.kie.workbench.common.screens.datasource.management.backend.core.DefDeployer;
import org.kie.workbench.common.screens.datasource.management.backend.service.DataSourceDefDeployerImpl;
import org.kie.workbench.common.screens.datasource.management.backend.service.DefRegistry;
import org.kie.workbench.common.screens.datasource.management.service.DataSourceDefQueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;

public abstract class AbstractDefDeployer<T>
implements DefDeployer {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceDefDeployerImpl.class);
    protected IOService ioService;
    protected DataSourceDefQueryService queryService;
    protected DataSourceRuntimeManager runtimeManager;
    protected DefRegistry defRegistry;

    public AbstractDefDeployer() {
    }

    public AbstractDefDeployer(IOService ioService, DataSourceDefQueryService queryService, DataSourceRuntimeManager runtimeManager, DefRegistry defRegistry) {
        this.ioService = ioService;
        this.queryService = queryService;
        this.runtimeManager = runtimeManager;
        this.defRegistry = defRegistry;
    }

    @Override
    public void deployGlobalDefs() {
        try {
            logger.debug("Starting global defs deployment");
            this.deployDefs(this.findGlobalDefs());
            logger.debug("End of global defs deployment");
        }
        catch (Exception e) {
            logger.error("Global defs deployment failed.", (Throwable)e);
        }
    }

    @Override
    public void deployProjectDefs(Path path) {
        try {
            logger.debug("Starting project defs deployment for path: " + path);
            this.deployDefs(this.findProjectDefs(path));
            logger.debug("End of project defs deployment for path: " + path);
        }
        catch (Exception e) {
            logger.error("Project defs deployment failed for paht: " + path, (Throwable)e);
        }
    }

    protected abstract Collection<T> findGlobalDefs();

    protected abstract Collection<T> findProjectDefs(Path var1);

    protected abstract void deployDef(T var1);

    private void deployDefs(Collection<T> defs) {
        for (T def : defs) {
            this.deployDef(def);
        }
    }
}

