/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.util.gzip;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.uberfire.backend.server.util.gzip.GzipHttpServletResponseWrapper;

public class GzipFilter
implements Filter {
    static final String GZIP = "gzip";
    static final String ORG_UBERFIRE_GZIP_ENABLE = "org.uberfire.gzip.enable";

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        switch (this.getAction(req)) {
            case HALT: {
                break;
            }
            case DO_NOT_ACCEPT_GZIP: 
            case DO_NOT_COMPRESS: {
                chain.doFilter(req, res);
                break;
            }
            case COMPRESS: {
                this.compressAndContinue(req, (HttpServletResponse)res, chain);
            }
        }
    }

    void compressAndContinue(ServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        GzipHttpServletResponseWrapper wResponse = new GzipHttpServletResponseWrapper(res);
        chain.doFilter(req, (ServletResponse)wResponse);
        wResponse.close();
    }

    Action getAction(ServletRequest req) {
        String enabled = System.getProperty(ORG_UBERFIRE_GZIP_ENABLE);
        if (enabled != null && !enabled.equals("true")) {
            return Action.DO_NOT_COMPRESS;
        }
        if (!(req instanceof HttpServletRequest)) {
            return Action.HALT;
        }
        String acceptEncodingHeader = ((HttpServletRequest)req).getHeader("Accept-Encoding");
        if (acceptEncodingHeader == null || !acceptEncodingHeader.contains(GZIP)) {
            return Action.DO_NOT_ACCEPT_GZIP;
        }
        return Action.COMPRESS;
    }

    public void destroy() {
    }

    static enum Action {
        HALT,
        DO_NOT_COMPRESS,
        DO_NOT_ACCEPT_GZIP,
        COMPRESS;

    }
}

