/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.service.backend.auth.impl;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.security.WorkbenchUserManager;
import org.uberfire.ssh.service.backend.auth.SSHKeyAuthenticator;
import org.uberfire.ssh.service.backend.auth.impl.SSHUser;
import org.uberfire.ssh.service.backend.keystore.SSHKeyStoreService;
import org.uberfire.ssh.service.backend.keystore.model.SSHPublicKey;

@ApplicationScoped
public class SSHKeyAuthenticatorImpl
implements SSHKeyAuthenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSHKeyAuthenticatorImpl.class);
    private final SSHKeyStoreService keyStoreService;
    private final WorkbenchUserManager userManager;

    @Inject
    public SSHKeyAuthenticatorImpl(SSHKeyStoreService keyStoreService, Instance<WorkbenchUserManager> workbenchUserManagerInstance) {
        this.keyStoreService = keyStoreService;
        if (!workbenchUserManagerInstance.isUnsatisfied() && !workbenchUserManagerInstance.isAmbiguous()) {
            this.userManager = (WorkbenchUserManager)workbenchUserManagerInstance.get();
        } else {
            LOGGER.warn("Cannot find any implementation of 'WorkbenchUserManager'. Loading default implementation on SSH module");
            this.userManager = this::getUser;
        }
    }

    public User authenticate(String userName, PublicKey key) {
        ArrayList keys;
        PublicKey resultKey;
        Optional<User> userOptional = Optional.ofNullable(this.userManager.getUser(userName));
        if (userOptional.isPresent() && (resultKey = KeyUtils.findMatchingKey((PublicKey)key, (Collection)(keys = new ArrayList(this.keyStoreService.keyStore().getUserKeys(userName))).stream().map(SSHPublicKey::getKey).collect(Collectors.toList()))) != null) {
            keys.stream().filter(userKey -> userKey.getKey().equals(resultKey)).findAny().ifPresent(userKey -> this.updateUserKey(userName, (SSHPublicKey)userKey));
            return userOptional.get();
        }
        return null;
    }

    private void updateUserKey(String userName, SSHPublicKey userKey) {
        userKey.getMetaData().setLastTimeUsed(new Date());
        this.keyStoreService.keyStore().updateUserKey(userName, userKey);
    }

    private User getUser(String identifier) {
        return new SSHUser(identifier);
    }
}

