/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.authorization;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SecurityActions {
    SecurityActions() {
    }

    static void setContextClassLoader(final ClassLoader tccl) throws PrivilegedActionException {
        AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                Thread.currentThread().setContextClassLoader(tccl);
                return null;
            }
        });
    }

    static ClassLoader getContextClassLoader() throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static Class<?> loadClass(final String name) throws PrivilegedActionException {
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws PrivilegedActionException {
                try {
                    return SecurityActions.getContextClassLoader().loadClass(name);
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
            }
        });
    }
}

