/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.openshift.storage;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.KieServerMode;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.services.impl.storage.KieServerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTemplateConverter {
    private static final Logger logger = LoggerFactory.getLogger(ServerTemplateConverter.class);
    private static final String SERVICE_PORT_ENV_SUFFIX = "_SERVICE_PORT";
    private static final String SERVICE_HOST_ENV_SUFFIX = "_SERVICE_HOST";
    private static final String SERVICE_PATH = "/services/rest/server";
    protected static final boolean PREFER_KIESERVER_SERVICE = Boolean.parseBoolean(System.getProperty("org.kie.server.controller.openshift.prefer.kieserver.service", "true"));

    private ServerTemplateConverter() {
    }

    public static ServerTemplate fromState(KieServerState state) {
        if (state == null) {
            return null;
        }
        if (state.getConfiguration() == null) {
            throw new IllegalArgumentException("Kie server configuration can not be empty.");
        }
        ServerTemplate template = new ServerTemplate();
        String id = state.getConfiguration().getConfigItemValue("org.kie.server.id");
        String name = state.getConfiguration().getConfigItemValue("org.kie.server.services.openshift.service.name", id);
        String mode = state.getConfiguration().getConfigItemValue("org.kie.server.mode", KieServerMode.DEVELOPMENT.name());
        Optional<String> urlOpt = ServerTemplateConverter.resolveServerUrl(state);
        template.setId(id);
        template.setName(name);
        urlOpt.ifPresent(url -> template.addServerInstance(new ServerInstanceKey(id, id, id, url)));
        for (KieContainerResource conRes : state.getContainers()) {
            EnumMap<Capability, Object> configs = new EnumMap<Capability, Object>(Capability.class);
            KieScannerResource scanner = conRes.getScanner();
            if (scanner != null) {
                configs.put(Capability.RULE, (Object)new RuleConfig(scanner.getPollInterval(), scanner.getStatus()));
            }
            ProcessConfig pcfg = null;
            for (KieServerConfigItem item : conRes.getConfigItems()) {
                if (!"BPM".equals(item.getType())) continue;
                ProcessConfig processConfig = pcfg = pcfg == null ? new ProcessConfig() : pcfg;
                if ("KBase".equals(item.getName())) {
                    pcfg.setKBase(item.getValue());
                }
                if ("KSession".equals(item.getName())) {
                    pcfg.setKSession(item.getValue());
                }
                if ("MergeMode".equals(item.getName())) {
                    pcfg.setMergeMode(item.getValue());
                }
                if (!"RuntimeStrategy".equals(item.getName())) continue;
                pcfg.setRuntimeStrategy(item.getValue());
            }
            if (pcfg != null) {
                configs.put(Capability.PROCESS, (Object)pcfg);
            }
            template.addContainerSpec(new ContainerSpec(conRes.getContainerId(), conRes.getContainerAlias(), new ServerTemplateKey(id, id), conRes.getReleaseId(), conRes.getStatus(), configs));
        }
        List capabilities = Stream.of(Capability.values()).map(Enum::name).collect(Collectors.toList());
        KieServerConfig kcfg = state.getConfiguration();
        if (kcfg.getConfigItem("org.jbpm.server.ext.disabled") != null) {
            capabilities.remove(Capability.PROCESS.name());
        }
        if (kcfg.getConfigItem("org.drools.server.ext.disabled") != null) {
            capabilities.remove(Capability.RULE.name());
        }
        if (kcfg.getConfigItem("org.optaplanner.server.ext.disabled") != null) {
            capabilities.remove(Capability.PLANNING.name());
        }
        template.setCapabilities(capabilities);
        template.setMode(KieServerMode.valueOf((String)mode.toUpperCase()));
        return template;
    }

    public static KieServerState toState(ServerTemplate template) {
        String id = template.getId();
        String name = template.getName();
        KieServerMode mode = template.getMode() == null ? KieServerMode.DEVELOPMENT : template.getMode();
        KieServerState state = new KieServerState();
        KieServerConfig config = new KieServerConfig();
        HashSet<KieContainerResource> containers = new HashSet<KieContainerResource>();
        config.addConfigItem(new KieServerConfigItem("org.kie.server.id", id, String.class.getName()));
        config.addConfigItem(new KieServerConfigItem("org.kie.server.services.openshift.service.name", name, String.class.getName()));
        config.addConfigItem(new KieServerConfigItem("org.kie.server.mode", mode.name(), String.class.getName()));
        if (template.getServerInstance(id) != null) {
            config.addConfigItem(new KieServerConfigItem("org.kie.server.location", template.getServerInstance(id).getUrl(), String.class.getName()));
        }
        List capabilities = template.getCapabilities();
        for (Capability cap : Arrays.asList(Capability.values())) {
            switch (cap) {
                case PROCESS: {
                    if (capabilities.contains(cap.name())) break;
                    config.addConfigItem(new KieServerConfigItem("org.jbpm.server.ext.disabled", "true", String.class.getName()));
                    break;
                }
                case RULE: {
                    if (capabilities.contains(cap.name())) break;
                    config.addConfigItem(new KieServerConfigItem("org.drools.server.ext.disabled", "true", String.class.getName()));
                    break;
                }
                case PLANNING: {
                    if (capabilities.contains(cap.name())) break;
                    config.addConfigItem(new KieServerConfigItem("org.optaplanner.server.ext.disabled", "true", String.class.getName()));
                    break;
                }
            }
        }
        for (ContainerSpec conSpec : template.getContainersSpec()) {
            KieContainerResource conRes = new KieContainerResource(conSpec.getId(), conSpec.getReleasedId());
            conRes.setContainerAlias(conSpec.getContainerName());
            conRes.setStatus(conSpec.getStatus());
            for (Map.Entry conCfgEntry : conSpec.getConfigs().entrySet()) {
                switch ((Capability)conCfgEntry.getKey()) {
                    case PROCESS: {
                        ProcessConfig pcfg = (ProcessConfig)conCfgEntry.getValue();
                        conRes.addConfigItem(new KieServerConfigItem("KBase", pcfg.getKBase(), "BPM"));
                        conRes.addConfigItem(new KieServerConfigItem("KSession", pcfg.getKSession(), "BPM"));
                        conRes.addConfigItem(new KieServerConfigItem("MergeMode", pcfg.getMergeMode(), "BPM"));
                        conRes.addConfigItem(new KieServerConfigItem("RuntimeStrategy", pcfg.getRuntimeStrategy(), "BPM"));
                        break;
                    }
                    case RULE: {
                        RuleConfig rcfg = (RuleConfig)conCfgEntry.getValue();
                        conRes.setScanner(new KieScannerResource(rcfg.getScannerStatus(), rcfg.getPollInterval()));
                        break;
                    }
                }
            }
            containers.add(conRes);
        }
        state.setConfiguration(config);
        state.setContainers(containers);
        return state;
    }

    protected static Optional<String> resolveServerUrl(KieServerState state) {
        String serverId = state.getConfiguration().getConfigItemValue("org.kie.server.id", "unknown");
        String serviceName = state.getConfiguration().getConfigItemValue("org.kie.server.services.openshift.service.name", "unknown");
        Optional<String> resolvedUrl = Optional.ofNullable(state.getConfiguration().getConfigItemValue("org.kie.server.location"));
        if (PREFER_KIESERVER_SERVICE && resolvedUrl.isPresent()) {
            String envPrefix = serviceName.replace('-', '_').toUpperCase();
            String servicePortEnv = System.getenv(envPrefix.concat(SERVICE_PORT_ENV_SUFFIX));
            String serviceHostEnv = System.getenv(envPrefix.concat(SERVICE_HOST_ENV_SUFFIX));
            String string = servicePortEnv = servicePortEnv == null ? "8080" : servicePortEnv;
            if (serviceHostEnv != null) {
                resolvedUrl = Optional.of(new StringBuffer("http://").append(serviceHostEnv).append(":").append(servicePortEnv).append(SERVICE_PATH).toString());
            } else {
                logger.warn("Environment variable: [{}] defined by OpenShift Cluster Service for KIE server: [{}] not found.", (Object)envPrefix.concat(SERVICE_HOST_ENV_SUFFIX), (Object)serverId);
                if (resolvedUrl.isPresent()) {
                    logger.warn("Use kie server location [{}]", (Object)resolvedUrl.get());
                } else {
                    logger.warn("Undefined kie server location");
                }
            }
        }
        return resolvedUrl;
    }
}

