/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.parser;

import java.io.InputStream;
import org.kie.workbench.common.services.datamodeller.parser.JavaFileHandler;
import org.kie.workbench.common.services.datamodeller.parser.JavaParser;
import org.kie.workbench.common.services.datamodeller.parser.JavaParserFactory;
import org.kie.workbench.common.services.datamodeller.parser.descr.FileDescr;
import org.kie.workbench.common.services.datamodeller.parser.util.ParserUtil;

public class JavaFileHandlerImpl
implements JavaFileHandler {
    private StringBuilder source = null;
    private JavaParser parser;
    private FileDescr fileDescr;

    public JavaFileHandlerImpl(InputStream inputStream) throws Exception {
        this.source = new StringBuilder(ParserUtil.readString(inputStream));
        this.parseSource();
    }

    public JavaFileHandlerImpl(String sourceString) throws Exception {
        this.source = new StringBuilder(sourceString);
        this.parseSource();
    }

    @Override
    public FileDescr getFileDescr() {
        return this.fileDescr;
    }

    @Override
    public String getOriginalContent() {
        return this.source.toString();
    }

    private void parseSource() throws Exception {
        this.parser = JavaParserFactory.newParser(this.source.toString());
        this.parser.compilationUnit();
        this.fileDescr = this.parser.getFileDescr();
        ParserUtil.setSourceBufferTMP(this.fileDescr, this.parser.getSourceBuffer());
        ParserUtil.populateUnManagedElements(this.fileDescr);
    }

    @Override
    public String buildResult() {
        return ParserUtil.printTree(this.fileDescr);
    }
}

